/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.ratelimiter;

import org.minbox.framework.api.boot.autoconfigure.ratelimiter.ApiBootRateLimiterNacosConfigConfiguration;
import org.minbox.framework.api.boot.autoconfigure.ratelimiter.ApiBootRateLimiterProperties;
import org.minbox.framework.api.boot.autoconfigure.ratelimiter.ApiBootRateLimiterRedisAutoConfiguration;
import org.minbox.framework.limiter.MinBoxRateLimiter;
import org.minbox.framework.limiter.aop.advisor.RateLimiterAdvisor;
import org.minbox.framework.limiter.aop.interceptor.RateLimiterMethodInterceptor;
import org.minbox.framework.limiter.centre.RateLimiterConfigCentre;
import org.minbox.framework.limiter.centre.support.DefaultRateLimiterConfigCentre;
import org.minbox.framework.limiter.result.RateLimiterOverFlowResponse;
import org.minbox.framework.limiter.support.GoogleGuavaRateLimiter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={MinBoxRateLimiter.class})
@EnableConfigurationProperties(value={ApiBootRateLimiterProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@Import(value={ApiBootRateLimiterRedisAutoConfiguration.class, ApiBootRateLimiterNacosConfigConfiguration.class})
public class ApiBootRateLimiterAutoConfiguration {
    private ApiBootRateLimiterProperties apiBootRateLimiterProperties;
    private RateLimiterOverFlowResponse rateLimiterOverFlowResponse;

    public ApiBootRateLimiterAutoConfiguration(ApiBootRateLimiterProperties apiBootRateLimiterProperties, ObjectProvider<RateLimiterOverFlowResponse> rateLimiterOverFlowRequestObjectProvider) {
        this.apiBootRateLimiterProperties = apiBootRateLimiterProperties;
        this.rateLimiterOverFlowResponse = (RateLimiterOverFlowResponse)rateLimiterOverFlowRequestObjectProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.redis.core.RedisTemplate"})
    public MinBoxRateLimiter googleGuavaRateLimiter(RateLimiterConfigCentre rateLimiterConfigCentre) {
        return new GoogleGuavaRateLimiter(Long.valueOf(this.apiBootRateLimiterProperties.isEnableGlobalQps() ? this.apiBootRateLimiterProperties.getGlobalQps() : 0L), rateLimiterConfigCentre);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"com.alibaba.boot.nacos.config.properties.NacosConfigProperties"})
    public RateLimiterConfigCentre defaultRateLimiterConfigCentre() {
        return new DefaultRateLimiterConfigCentre();
    }

    @Bean
    @ConditionalOnMissingBean
    RateLimiterAdvisor rateLimiterAdvisor(RateLimiterMethodInterceptor rateLimiterMethodInterceptor) {
        return new RateLimiterAdvisor(rateLimiterMethodInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    RateLimiterMethodInterceptor rateLimiterMethodInterceptor(MinBoxRateLimiter apiBootRateLimiter) {
        return new RateLimiterMethodInterceptor(apiBootRateLimiter, this.rateLimiterOverFlowResponse);
    }
}

