/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.ratelimiter;

import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigAutoConfiguration;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Objects;
import java.util.Properties;
import org.minbox.framework.limiter.centre.RateLimiterConfigCentre;
import org.minbox.framework.limiter.centre.support.NacosRateLimiterConfigCentre;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"com.alibaba.boot.nacos.config.properties.NacosConfigProperties"})
@EnableConfigurationProperties(value={NacosConfigProperties.class})
@AutoConfigureAfter(value={NacosConfigAutoConfiguration.class})
public class ApiBootRateLimiterNacosConfigConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootRateLimiterNacosConfigConfiguration.class);
    static final String NACOS_CONFIG_SERVICE_NAME = "nacosConfigService";
    private NacosConfigProperties nacosConfigProperties;

    public ApiBootRateLimiterNacosConfigConfiguration(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
        logger.info("ApiBoot RateLimiter nacos config centre is instantiated.");
    }

    @Bean
    @ConditionalOnMissingBean
    public RateLimiterConfigCentre nacosRateLimiterConfigCentre(@Qualifier(value="nacosConfigService") ConfigService configService) {
        return new NacosRateLimiterConfigCentre(configService);
    }

    @Bean
    @ConditionalOnMissingBean(name={"nacosConfigService"})
    public ConfigService nacosConfigService() throws NacosException {
        Properties properties = new Properties();
        properties.put("serverAddr", Objects.toString(this.nacosConfigProperties.getServerAddr(), ""));
        properties.put("encode", Objects.toString(this.nacosConfigProperties.getEncode(), ""));
        properties.put("namespace", Objects.toString(this.nacosConfigProperties.getNamespace(), ""));
        properties.put("accessKey", Objects.toString(this.nacosConfigProperties.getAccessKey(), ""));
        properties.put("secretKey", Objects.toString(this.nacosConfigProperties.getSecretKey(), ""));
        properties.put("contextPath", Objects.toString(this.nacosConfigProperties.getContextPath(), ""));
        properties.put("endpoint", Objects.toString(this.nacosConfigProperties.getEndpoint(), ""));
        return NacosFactory.createConfigService((Properties)properties);
    }
}

