/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.ratelimiter;

import org.minbox.framework.api.boot.autoconfigure.ratelimiter.ApiBootRateLimiterProperties;
import org.minbox.framework.limiter.MinBoxRateLimiter;
import org.minbox.framework.limiter.centre.RateLimiterConfigCentre;
import org.minbox.framework.limiter.support.RedisLuaRateLimiter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableConfigurationProperties(value={ApiBootRateLimiterProperties.class})
@ConditionalOnClass(name={"org.springframework.data.redis.core.RedisTemplate"})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class ApiBootRateLimiterRedisAutoConfiguration {
    private ApiBootRateLimiterProperties apiBootRateLimiterProperties;

    public ApiBootRateLimiterRedisAutoConfiguration(ApiBootRateLimiterProperties apiBootRateLimiterProperties) {
        this.apiBootRateLimiterProperties = apiBootRateLimiterProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public MinBoxRateLimiter redisLuaRateLimiter(RedisTemplate redisTemplate, RateLimiterConfigCentre rateLimiterConfigCentre) {
        return new RedisLuaRateLimiter(Long.valueOf(this.apiBootRateLimiterProperties.isEnableGlobalQps() ? this.apiBootRateLimiterProperties.getGlobalQps() : 0L), rateLimiterConfigCentre, redisTemplate);
    }
}

