/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.resource;

import org.minbox.framework.api.boot.autoconfigure.resource.ApiBootResourceRedisLoadAutoConfiguration;
import org.minbox.framework.resource.ResourceStoreDelegate;
import org.minbox.framework.resource.aop.advistor.ResourceLoadAdvisor;
import org.minbox.framework.resource.aop.interceptor.ResourceLoadMethodInterceptor;
import org.minbox.framework.resource.pusher.ResourcePusher;
import org.minbox.framework.resource.pusher.support.MemoryResourcePusher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={ResourceStoreDelegate.class})
@Import(value={ApiBootResourceRedisLoadAutoConfiguration.class})
public class ApiBootResourceLoadAutoConfiguration {
    private ResourceStoreDelegate resourceStoreDelegate;

    public ApiBootResourceLoadAutoConfiguration(ObjectProvider<ResourceStoreDelegate> resourceStoreDelegateObjectProvider) {
        this.resourceStoreDelegate = (ResourceStoreDelegate)resourceStoreDelegateObjectProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    ResourceLoadAdvisor resourceLoadAdvisor(ResourceLoadMethodInterceptor resourceLoadMethodInterceptor) {
        return new ResourceLoadAdvisor(resourceLoadMethodInterceptor);
    }

    @Bean
    @ConditionalOnMissingBean
    ResourceLoadMethodInterceptor resourceLoadMethodInterceptor(ResourcePusher apiBootResourcePusher) {
        return new ResourceLoadMethodInterceptor(apiBootResourcePusher);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.data.redis.core.RedisTemplate"})
    MemoryResourcePusher apiBootMemoryResourcePusher() {
        return new MemoryResourcePusher(this.resourceStoreDelegate);
    }
}

