/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.resource;

import org.minbox.framework.resource.ResourceStoreDelegate;
import org.minbox.framework.resource.pusher.support.RedisResourcePusher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@ConditionalOnClass(value={RedisTemplate.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class ApiBootResourceRedisLoadAutoConfiguration {
    private ResourceStoreDelegate resourceStoreDelegate;

    public ApiBootResourceRedisLoadAutoConfiguration(ObjectProvider<ResourceStoreDelegate> resourceStoreDelegateObjectProvider) {
        this.resourceStoreDelegate = (ResourceStoreDelegate)resourceStoreDelegateObjectProvider.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    RedisResourcePusher apiBootRedisResourcePusher(RedisTemplate redisTemplate) {
        return new RedisResourcePusher(this.resourceStoreDelegate, redisTemplate);
    }
}

