/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.security.SecurityAway;
import org.minbox.framework.security.SecurityUser;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="api.boot.security")
public class ApiBootSecurityProperties {
    public static final String API_BOOT_SECURITY_PREFIX = "api.boot.security";
    public static final String[] DEFAULT_IGNORE_URLS = new String[]{"/v2/api-docs", "/swagger-ui.html", "/swagger-resources/configuration/security", "/META-INF/resources/webjars/**", "/webjars/**", "/swagger-resources", "/swagger-resources/configuration/ui", "/actuator/**"};
    private String[] authPrefix = new String[]{"/api/**"};
    private SecurityAway away = SecurityAway.memory;
    private List<SecurityUser> users = new ArrayList<SecurityUser>();
    private String[] ignoringUrls;
    private boolean enableDefaultStoreDelegate = true;
    private boolean disableHttpBasic = true;
    private boolean disableCsrf = true;

    public String[] getAuthPrefix() {
        return this.authPrefix;
    }

    public SecurityAway getAway() {
        return this.away;
    }

    public List<SecurityUser> getUsers() {
        return this.users;
    }

    public String[] getIgnoringUrls() {
        return this.ignoringUrls;
    }

    public boolean isEnableDefaultStoreDelegate() {
        return this.enableDefaultStoreDelegate;
    }

    public boolean isDisableHttpBasic() {
        return this.disableHttpBasic;
    }

    public boolean isDisableCsrf() {
        return this.disableCsrf;
    }

    public void setAuthPrefix(String[] authPrefix) {
        this.authPrefix = authPrefix;
    }

    public void setAway(SecurityAway away) {
        this.away = away;
    }

    public void setUsers(List<SecurityUser> users) {
        this.users = users;
    }

    public void setIgnoringUrls(String[] ignoringUrls) {
        this.ignoringUrls = ignoringUrls;
    }

    public void setEnableDefaultStoreDelegate(boolean enableDefaultStoreDelegate) {
        this.enableDefaultStoreDelegate = enableDefaultStoreDelegate;
    }

    public void setDisableHttpBasic(boolean disableHttpBasic) {
        this.disableHttpBasic = disableHttpBasic;
    }

    public void setDisableCsrf(boolean disableCsrf) {
        this.disableCsrf = disableCsrf;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiBootSecurityProperties)) {
            return false;
        }
        ApiBootSecurityProperties other = (ApiBootSecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableDefaultStoreDelegate() != other.isEnableDefaultStoreDelegate()) {
            return false;
        }
        if (this.isDisableHttpBasic() != other.isDisableHttpBasic()) {
            return false;
        }
        if (this.isDisableCsrf() != other.isDisableCsrf()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAuthPrefix(), other.getAuthPrefix())) {
            return false;
        }
        SecurityAway this$away = this.getAway();
        SecurityAway other$away = other.getAway();
        if (this$away == null ? other$away != null : !((Object)((Object)this$away)).equals((Object)other$away)) {
            return false;
        }
        List<SecurityUser> this$users = this.getUsers();
        List<SecurityUser> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        return Arrays.deepEquals(this.getIgnoringUrls(), other.getIgnoringUrls());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiBootSecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableDefaultStoreDelegate() ? 79 : 97);
        result = result * 59 + (this.isDisableHttpBasic() ? 79 : 97);
        result = result * 59 + (this.isDisableCsrf() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getAuthPrefix());
        SecurityAway $away = this.getAway();
        result = result * 59 + ($away == null ? 43 : ((Object)((Object)$away)).hashCode());
        List<SecurityUser> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIgnoringUrls());
        return result;
    }

    public String toString() {
        return "ApiBootSecurityProperties(authPrefix=" + Arrays.deepToString(this.getAuthPrefix()) + ", away=" + (Object)((Object)this.getAway()) + ", users=" + this.getUsers() + ", ignoringUrls=" + Arrays.deepToString(this.getIgnoringUrls()) + ", enableDefaultStoreDelegate=" + this.isEnableDefaultStoreDelegate() + ", disableHttpBasic=" + this.isDisableHttpBasic() + ", disableCsrf=" + this.isDisableCsrf() + ")";
    }
}

