/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.security;

import javax.sql.DataSource;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootSecurityProperties;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootWebSecurityAutoConfiguration;
import org.minbox.framework.security.WebSecurityConfiguration;
import org.minbox.framework.security.delegate.DefaultSecurityStoreDelegate;
import org.minbox.framework.security.delegate.SecurityStoreDelegate;
import org.minbox.framework.security.userdetails.SecurityUserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableConfigurationProperties(value={ApiBootSecurityProperties.class})
@ConditionalOnClass(value={WebSecurityConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="api.boot.security", name={"away"}, havingValue="jdbc")
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class ApiBootWebSecurityJdbcAutoConfiguration
extends ApiBootWebSecurityAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootWebSecurityJdbcAutoConfiguration.class);

    public ApiBootWebSecurityJdbcAutoConfiguration(ApiBootSecurityProperties apiBootSecurityProperties, ObjectProvider<AccessDeniedHandler> accessDeniedHandler, ObjectProvider<AuthenticationEntryPoint> authenticationEntryPoint) {
        super(apiBootSecurityProperties, (AccessDeniedHandler)accessDeniedHandler.getIfAvailable(), (AuthenticationEntryPoint)authenticationEntryPoint.getIfAvailable());
        logger.info("ApiBoot Security initialize using jdbc.");
    }

    @Bean
    protected UserDetailsService userDetailsService() {
        return new SecurityUserDetailsService();
    }

    @Bean
    @ConditionalOnProperty(prefix="api.boot.security", name={"enable-default-store-delegate"}, havingValue="true", matchIfMissing=true)
    public SecurityStoreDelegate apiBootStoreDelegate(DataSource dataSource) {
        return new DefaultSecurityStoreDelegate(dataSource);
    }
}

