/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.security;

import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootSecurityProperties;
import org.minbox.framework.api.boot.autoconfigure.security.ApiBootWebSecurityAutoConfiguration;
import org.minbox.framework.security.SecurityUser;
import org.minbox.framework.security.WebSecurityConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@EnableConfigurationProperties(value={ApiBootSecurityProperties.class})
@ConditionalOnClass(value={WebSecurityConfiguration.class})
@ConditionalOnProperty(prefix="api.boot.security", name={"away"}, havingValue="memory", matchIfMissing=true)
public class ApiBootWebSecurityMemoryAutoConfiguration
extends ApiBootWebSecurityAutoConfiguration {
    static Logger logger = LoggerFactory.getLogger(ApiBootWebSecurityMemoryAutoConfiguration.class);

    public ApiBootWebSecurityMemoryAutoConfiguration(ApiBootSecurityProperties apiBootSecurityProperties, ObjectProvider<AccessDeniedHandler> accessDeniedHandler, ObjectProvider<AuthenticationEntryPoint> authenticationEntryPoint) {
        super(apiBootSecurityProperties, (AccessDeniedHandler)accessDeniedHandler.getIfAvailable(), (AuthenticationEntryPoint)authenticationEntryPoint.getIfAvailable());
        logger.info("ApiBoot Security initialize using memory.");
    }

    @Bean
    protected UserDetailsService userDetailsService() {
        InMemoryUserDetailsManager memoryUserDetailsManager = new InMemoryUserDetailsManager();
        List<SecurityUser> users = this.apiBootSecurityProperties.getUsers();
        users.forEach(securityUser -> {
            String encoderPassword = this.passwordEncoder().encode((CharSequence)securityUser.getPassword());
            UserDetails userDetails = User.builder().username(securityUser.getUsername()).password(encoderPassword).roles(securityUser.getRoles()).build();
            memoryUserDetailsManager.createUser(userDetails);
        });
        return memoryUserDetailsManager;
    }
}

