/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.ssh;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.minbox.framework.api.boot.autoconfigure.ssh.SshAgentProperties;
import org.minbox.framework.ssh.agent.AgentConnection;
import org.minbox.framework.ssh.agent.DefaultAgentConnection;
import org.minbox.framework.ssh.agent.config.AgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ObjectUtils;

@Configuration
@WebListener
public class SshAgentServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(SshAgentServletContextListener.class);
    private SshAgentProperties sshAgentProperties;
    private List<AgentConnection> connections = new ArrayList<AgentConnection>();

    public SshAgentServletContextListener(SshAgentProperties sshAgentProperties) {
        this.sshAgentProperties = sshAgentProperties;
    }

    public void contextInitialized(ServletContextEvent sce) {
        List<AgentConfig> configs = this.sshAgentProperties.getConfigs();
        if (ObjectUtils.isEmpty(configs)) {
            log.warn("ssh-agent agent does not take effect, reason: agent information is not configured.");
            return;
        }
        configs.stream().forEach(config -> {
            try {
                DefaultAgentConnection connection = new DefaultAgentConnection(config);
                this.connections.add((AgentConnection)connection);
                connection.connect();
            }
            catch (Exception e) {
                log.error("Connection\uff1a{}:{}\uff0ctry agent failure.", new Object[]{config.getServerIp(), config.getForwardTargetPort(), e});
            }
        });
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.connections.stream().forEach(connection -> connection.disconnect());
    }
}

