/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.autoconfigure.swagger;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.minbox.framework.api.boot.autoconfigure.swagger.SwaggerProperties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.configuration.SwaggerCommonConfiguration;
import springfox.documentation.swagger.web.ApiKeyVehicle;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;
import springfox.documentation.swagger2.web.Swagger2Controller;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnClass(value={SwaggerCommonConfiguration.class, Swagger2DocumentationConfiguration.class, Swagger2Controller.class})
@ConditionalOnProperty(prefix="api.boot.swagger", name={"enable"}, havingValue="true", matchIfMissing=true)
@Import(value={Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
public class ApiBootSwaggerAutoConfiguration {
    private static final String AUTHORIZATION_SCOPE = "global";
    private static final String AUTHORIZATION_SCOPE_DESCRIPTION = "accessEverything";
    private SwaggerProperties swaggerProperties;
    private BeanFactory beanFactory;

    public ApiBootSwaggerAutoConfiguration(SwaggerProperties swaggerProperties, BeanFactory beanFactory) {
        this.swaggerProperties = swaggerProperties;
        this.beanFactory = beanFactory;
    }

    @Bean
    public Docket docket() {
        String basePackage = this.swaggerProperties.getBasePackage();
        if (StringUtils.isEmpty((Object)basePackage)) {
            basePackage = (String)AutoConfigurationPackages.get((BeanFactory)this.beanFactory).get(0);
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).securitySchemes(Collections.singletonList(this.apiKey())).securityContexts(Collections.singletonList(this.securityContext())).select().apis(RequestHandlerSelectors.basePackage((String)basePackage)).paths(PathSelectors.any()).build();
    }

    public ApiInfo apiInfo() {
        Contact contact = this.convertContact(this.swaggerProperties.getContact());
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).version(this.swaggerProperties.getVersion()).license(this.swaggerProperties.getLicense()).licenseUrl(this.swaggerProperties.getLicenseUrl()).contact(contact).build();
    }

    private ApiKey apiKey() {
        return new ApiKey(this.swaggerProperties.getAuthorization().getName(), this.swaggerProperties.getAuthorization().getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)this.swaggerProperties.getAuthorization().getAuthRegex())).build();
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope(AUTHORIZATION_SCOPE, AUTHORIZATION_SCOPE_DESCRIPTION);
        AuthorizationScope[] authorizationScopes = (AuthorizationScope[])Arrays.asList(authorizationScope).stream().toArray(AuthorizationScope[]::new);
        SecurityReference securityReference = SecurityReference.builder().reference(this.swaggerProperties.getAuthorization().getName()).scopes(authorizationScopes).build();
        return Collections.singletonList(securityReference);
    }

    private Contact convertContact(SwaggerProperties.Contact contact) {
        return new Contact(contact.getName(), contact.getWebsite(), contact.getEmail());
    }
}

