/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.plugin.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.minbox.framework.api.boot.plugin.oss.progress.ApiBootObjectStorageProgress;
import org.minbox.framework.api.boot.plugin.oss.progress.OssProgressListener;
import org.minbox.framework.api.boot.plugin.storage.ApiBootObjectStorageService;
import org.minbox.framework.api.boot.plugin.storage.exception.ApiBootObjectStorageException;
import org.minbox.framework.api.boot.plugin.storage.response.ApiBootObjectStorageResponse;

public class ApiBootOssService
implements ApiBootObjectStorageService {
    protected String endpoint;
    protected String bucketName;
    protected String accessKeyId;
    protected String accessKeySecret;
    protected String domain;
    private ApiBootObjectStorageProgress apiBootObjectStorageProgress;

    public ApiBootOssService(String endpoint, String bucketName, String accessKeyId, String accessKeySecret, String domain) {
        this.endpoint = endpoint;
        this.bucketName = bucketName;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.domain = domain;
    }

    public ApiBootObjectStorageResponse upload(String objectName, byte[] bytes) throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = this.getOssClient();
            ossClient.putObject((PutObjectRequest)new PutObjectRequest(this.bucketName, objectName, (InputStream)new ByteArrayInputStream(bytes)).withProgressListener((ProgressListener)new OssProgressListener(objectName, this.apiBootObjectStorageProgress)));
            this.closeOssClient(ossClient);
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException(e.getMessage(), (Throwable)e);
        }
        return ApiBootObjectStorageResponse.builder().objectName(objectName).objectUrl(this.getObjectUrl(objectName)).build();
    }

    public ApiBootObjectStorageResponse upload(String objectName, InputStream inputStream) throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = this.getOssClient();
            ossClient.putObject((PutObjectRequest)new PutObjectRequest(this.bucketName, objectName, inputStream).withProgressListener((ProgressListener)new OssProgressListener(objectName, this.apiBootObjectStorageProgress)));
            this.closeOssClient(ossClient);
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException(e.getMessage(), (Throwable)e);
        }
        return ApiBootObjectStorageResponse.builder().objectName(objectName).objectUrl(this.getObjectUrl(objectName)).build();
    }

    public ApiBootObjectStorageResponse upload(String objectName, String localFile) throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = this.getOssClient();
            ossClient.putObject((PutObjectRequest)new PutObjectRequest(this.bucketName, objectName, new File(localFile)).withProgressListener((ProgressListener)new OssProgressListener(objectName, this.apiBootObjectStorageProgress)));
            this.closeOssClient(ossClient);
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException(e.getMessage(), (Throwable)e);
        }
        return ApiBootObjectStorageResponse.builder().objectName(objectName).objectUrl(this.getObjectUrl(objectName)).build();
    }

    public void download(String objectName, String localFile) throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = this.getOssClient();
            ossClient.getObject((GetObjectRequest)new GetObjectRequest(this.bucketName, objectName).withProgressListener((ProgressListener)new OssProgressListener(objectName, this.apiBootObjectStorageProgress)), new File(localFile));
            this.closeOssClient(ossClient);
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(String objectName) throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = this.getOssClient();
            ossClient.deleteObject(this.bucketName, objectName);
            this.closeOssClient(ossClient);
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException(e.getMessage(), (Throwable)e);
        }
    }

    public ApiBootObjectStorageResponse multipartUpload(String objectName, File uploadFile, long partSize) throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = this.getOssClient();
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, objectName);
            InitiateMultipartUploadResult result = ossClient.initiateMultipartUpload(request);
            String uploadId = result.getUploadId();
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            long fileLength = uploadFile.length();
            int partCount = (int)(fileLength / partSize);
            if (fileLength % partSize != 0L) {
                ++partCount;
            }
            for (int i = 0; i < partCount; ++i) {
                long startPos = (long)i * partSize;
                long curPartSize = i + 1 == partCount ? fileLength - startPos : partSize;
                FileInputStream is = new FileInputStream(uploadFile);
                ((InputStream)is).skip(startPos);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(this.bucketName);
                uploadPartRequest.setKey(objectName);
                uploadPartRequest.setUploadId(uploadId);
                uploadPartRequest.setInputStream((InputStream)is);
                uploadPartRequest.setPartSize(curPartSize);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResult uploadPartResult = ossClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
            }
            Collections.sort(partETags, Comparator.comparingInt(PartETag::getPartNumber));
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucketName, objectName, uploadId, partETags);
            ossClient.completeMultipartUpload(completeMultipartUploadRequest);
            this.closeOssClient(ossClient);
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException(e.getMessage(), (Throwable)e);
        }
        return ApiBootObjectStorageResponse.builder().objectName(objectName).objectUrl(this.getObjectUrl(objectName)).build();
    }

    public ApiBootObjectStorageResponse multipartUpload(String objectName, String localFile, long partSize) throws ApiBootObjectStorageException {
        File uploadFile = new File(localFile);
        return this.multipartUpload(objectName, uploadFile, partSize);
    }

    protected OSSClient getOssClient() throws ApiBootObjectStorageException {
        try {
            OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
            return ossClient;
        }
        catch (Exception e) {
            throw new ApiBootObjectStorageException("\u83b7\u53d6OssClient\u5bf9\u8c61\u5f02\u5e38.", (Throwable)e);
        }
    }

    protected void closeOssClient(OSSClient ossClient) throws ApiBootObjectStorageException {
        ossClient.shutdown();
    }

    protected String getDefaultObjectUrl(String objectName) {
        return String.format("https://%s.%s/%s", this.bucketName, this.endpoint.replace("http://", ""), objectName);
    }

    protected String getObjectUrl(String objectName) {
        if (this.domain != null && this.domain.length() > 0) {
            return String.format(this.domain + "/%s", objectName);
        }
        return this.getDefaultObjectUrl(objectName);
    }

    public void setApiBootObjectStorageProgress(ApiBootObjectStorageProgress apiBootObjectStorageProgress) {
        this.apiBootObjectStorageProgress = apiBootObjectStorageProgress;
    }
}

