/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.plugin.oss.progress;

import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import java.math.BigDecimal;
import org.minbox.framework.api.boot.plugin.oss.progress.ApiBootObjectStorageProgress;

public class OssProgressListener
implements ProgressListener {
    private long bytesWritten = 0L;
    private long totalBytes = -1L;
    private int percentScale = 2;
    private String objectName;
    private ApiBootObjectStorageProgress apiBootObjectStorageProgress;

    public OssProgressListener(String objectName, ApiBootObjectStorageProgress apiBootObjectStorageProgress) {
        this.objectName = objectName;
        this.apiBootObjectStorageProgress = apiBootObjectStorageProgress;
    }

    public void progressChanged(ProgressEvent progressEvent) {
        if (this.apiBootObjectStorageProgress != null) {
            long bytes = progressEvent.getBytes();
            ProgressEventType eventType = progressEvent.getEventType();
            switch (eventType) {
                case REQUEST_CONTENT_LENGTH_EVENT: {
                    this.totalBytes = bytes;
                    break;
                }
                case REQUEST_BYTE_TRANSFER_EVENT: {
                    this.bytesWritten += bytes;
                    if (this.totalBytes == -1L) break;
                    double percent = (double)this.bytesWritten * 100.0 / (double)this.totalBytes;
                    BigDecimal decimal = BigDecimal.valueOf(percent).setScale(this.percentScale, 1);
                    this.apiBootObjectStorageProgress.progress(this.objectName, decimal.doubleValue(), this.totalBytes, this.bytesWritten);
                    break;
                }
                case TRANSFER_COMPLETED_EVENT: {
                    this.apiBootObjectStorageProgress.success(this.objectName);
                    break;
                }
                case TRANSFER_FAILED_EVENT: {
                    this.apiBootObjectStorageProgress.failed(this.objectName);
                    break;
                }
            }
        }
    }
}

