/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.plugin.mail;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dm.model.v20151123.SingleSendMailRequest;
import com.aliyuncs.dm.model.v20151123.SingleSendMailResponse;
import org.minbox.framework.api.boot.common.exception.ApiBootException;
import org.minbox.framework.api.boot.plugin.mail.ApiBootMailService;
import org.minbox.framework.api.boot.plugin.mail.ContentType;
import org.minbox.framework.api.boot.plugin.mail.request.ApiBootMailRequest;
import org.minbox.framework.api.boot.plugin.mail.response.ApiBootMailResponse;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ApiBootAliYunMailService
implements ApiBootMailService {
    static final String JOIN_SPLIT = ",";
    private IAcsClient client;
    private String accountName;
    private boolean replyToAddress;
    private int addressType;
    private String defaultFromAlias;
    private String defaultTagName;

    public ApiBootMailResponse sendMail(ApiBootMailRequest apiBootMailRequest) throws ApiBootException {
        try {
            String tagName;
            this.checkParam(apiBootMailRequest);
            SingleSendMailRequest request = new SingleSendMailRequest();
            request.setAccountName(this.accountName);
            request.setFromAlias(StringUtils.isEmpty((Object)apiBootMailRequest.getFormAlias()) ? this.defaultFromAlias : apiBootMailRequest.getFormAlias());
            request.setAddressType(Integer.valueOf(this.addressType));
            String string = tagName = StringUtils.isEmpty((Object)apiBootMailRequest.getTagName()) ? this.defaultTagName : apiBootMailRequest.getTagName();
            if (!StringUtils.isEmpty((Object)tagName)) {
                request.setTagName(tagName);
            }
            request.setReplyToAddress(Boolean.valueOf(this.replyToAddress));
            request.setToAddress(String.join((CharSequence)JOIN_SPLIT, apiBootMailRequest.getToAddress()));
            request.setSubject(apiBootMailRequest.getSubject());
            this.switchBody(request, apiBootMailRequest.getContent(), apiBootMailRequest.getContentType());
            SingleSendMailResponse response = (SingleSendMailResponse)this.client.getAcsResponse((AcsRequest)request);
            return ApiBootMailResponse.builder().success(!StringUtils.isEmpty((Object)response.getRequestId())).build();
        }
        catch (Exception e) {
            throw new ApiBootException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkParam(ApiBootMailRequest request) throws ApiBootException {
        if (StringUtils.isEmpty((Object)request.getContent())) {
            throw new ApiBootException("ApiBoot Mail Request Param\uff1a[contentType] is required.");
        }
        if (StringUtils.isEmpty((Object)request.getToAddress())) {
            throw new ApiBootException("ApiBoot Mail Request Param\uff1a[toAddress] is required.");
        }
        if (StringUtils.isEmpty((Object)request.getSubject())) {
            throw new ApiBootException("ApiBoot Mail Request Param\uff1a[subject] is required.");
        }
    }

    private void switchBody(SingleSendMailRequest request, String content, ContentType contentType) {
        if (ObjectUtils.isEmpty((Object)contentType)) {
            request.setTextBody(content);
        } else {
            switch (contentType) {
                case HTML: {
                    request.setHtmlBody(content);
                    break;
                }
                case TEXT: {
                    request.setTextBody(content);
                }
            }
        }
    }

    public ApiBootAliYunMailService(IAcsClient client, String accountName, boolean replyToAddress, int addressType, String defaultFromAlias, String defaultTagName) {
        this.client = client;
        this.accountName = accountName;
        this.replyToAddress = replyToAddress;
        this.addressType = addressType;
        this.defaultFromAlias = defaultFromAlias;
        this.defaultTagName = defaultTagName;
    }
}

