/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.api.boot.plugin.security.delegate;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.minbox.framework.api.boot.common.exception.ApiBootException;
import org.minbox.framework.api.boot.plugin.security.delegate.ApiBootStoreDelegate;
import org.minbox.framework.api.boot.plugin.security.userdetails.ApiBootDefaultUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.ObjectUtils;

public class ApiBootDefaultStoreDelegate
implements ApiBootStoreDelegate {
    static Logger logger = LoggerFactory.getLogger(ApiBootDefaultStoreDelegate.class);
    static String DEFAULT_SELECT_USER_SQL = "SELECT UI_ID, UI_USER_NAME, UI_NICK_NAME, UI_PASSWORD, UI_EMAIL, UI_AGE, UI_ADDRESS, UI_IS_LOCKED, UI_IS_ENABLED, UI_STATUS, UI_CREATE_TIME FROM API_BOOT_USER_INFO";
    @Autowired
    private DataSource dataSource;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        ApiBootDefaultUserDetails userDetails = this.findUser(username);
        if (userDetails == null) {
            throw new UsernameNotFoundException("\u7528\u6237\uff1a" + username + "\u4e0d\u5b58\u5728");
        }
        logger.debug("Load user \uff1a{} complete.", (Object)username);
        return userDetails;
    }

    private ApiBootDefaultUserDetails findUser(String username) {
        ApiBootDefaultUserDetails apiBootDefaultUserDetails;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(DEFAULT_SELECT_USER_SQL);
            resultSet = ps.executeQuery();
            apiBootDefaultUserDetails = this.wrapperOneResult(ApiBootDefaultUserDetails.class, resultSet);
        }
        catch (Exception e) {
            try {
                throw new UsernameNotFoundException("Username\uff1a" + username + "\uff0cnot found.");
            }
            catch (Throwable throwable) {
                ApiBootDefaultStoreDelegate.closeResultSet(resultSet);
                ApiBootDefaultStoreDelegate.closeStatement(ps);
                ApiBootDefaultStoreDelegate.closeConnection(connection);
                throw throwable;
            }
        }
        ApiBootDefaultStoreDelegate.closeResultSet(resultSet);
        ApiBootDefaultStoreDelegate.closeStatement(ps);
        ApiBootDefaultStoreDelegate.closeConnection(connection);
        return apiBootDefaultUserDetails;
    }

    private static void closeConnection(Connection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeStatement(Statement statement) {
        if (null != statement) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private <T> T wrapperOneResult(Class<T> resultClass, ResultSet rs) throws ApiBootException {
        T resultObj = null;
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int columnCount = metaData.getColumnCount();
            while (rs.next()) {
                resultObj = resultClass.newInstance();
                for (int index = 1; index < columnCount + 1; ++index) {
                    Field field;
                    String columnName = metaData.getColumnName(index);
                    Object columnValue = rs.getObject(columnName);
                    if (columnValue == null) continue;
                    String fieldName = this.columnNameToFieldName(columnName);
                    try {
                        field = resultClass.getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException e) {
                        try {
                            field = resultClass.getSuperclass().getDeclaredField(fieldName);
                        }
                        catch (NoSuchFieldException e2) {
                            throw new ApiBootException("No such filed \uff1a " + fieldName);
                        }
                    }
                    field.setAccessible(true);
                    field.set(resultObj, columnValue);
                }
            }
        }
        catch (Exception e) {
            throw new ApiBootException("Encapsulation result set object encounters exception information\uff1a" + e.getMessage(), (Throwable)e);
        }
        return ObjectUtils.isEmpty(resultObj) ? null : resultObj;
    }

    private String columnNameToFieldName(String columnName) {
        String fieldName = columnName.toLowerCase();
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
    }
}

