/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.logging.admin.endpoint;

import org.minbox.framework.logging.admin.event.ReportLogEvent;
import org.minbox.framework.logging.core.LoggingClientNotice;
import org.minbox.framework.logging.core.annotation.Endpoint;
import org.minbox.framework.logging.core.response.ReportResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Endpoint
public class LoggingEndpoint
implements ApplicationContextAware {
    public static final String BEAN_NAME = "loggingEndpoint";
    static Logger logger = LoggerFactory.getLogger(LoggingEndpoint.class);
    private ApplicationContext applicationContext;

    @PostMapping(value={"/logging/report"})
    @ResponseBody
    public ResponseEntity<ReportResponse> report(@RequestBody LoggingClientNotice notice) {
        boolean reportSuccess = true;
        try {
            this.applicationContext.publishEvent((ApplicationEvent)new ReportLogEvent(this, notice));
        }
        catch (Exception e) {
            reportSuccess = false;
            logger.error(e.getMessage(), (Throwable)e);
        }
        ReportResponse response = new ReportResponse();
        response.setStatus(reportSuccess ? "SUCCESS" : "ERROR");
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

