/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.logging.admin.listener;

import com.alibaba.fastjson.JSON;
import org.minbox.framework.logging.admin.LoggingAdminFactoryBean;
import org.minbox.framework.logging.admin.endpoint.LoggingEndpoint;
import org.minbox.framework.logging.admin.event.ReportLogEvent;
import org.minbox.framework.logging.core.LoggingClientNotice;
import org.minbox.framework.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class ReportLogJsonFormatListener
implements SmartApplicationListener {
    public static final String BEAN_NAME = "reportLogJsonFormatListener";
    static Logger logger = LoggerFactory.getLogger(ReportLogJsonFormatListener.class);
    private LoggingAdminFactoryBean loggingAdminFactoryBean;

    public ReportLogJsonFormatListener(LoggingAdminFactoryBean loggingAdminFactoryBean) {
        this.loggingAdminFactoryBean = loggingAdminFactoryBean;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        try {
            ReportLogEvent reportLogEvent = (ReportLogEvent)event;
            if (this.loggingAdminFactoryBean.isShowConsoleReportLog()) {
                LoggingClientNotice notice = reportLogEvent.getLogClientNotice();
                String serviceInfo = String.format("%s -> %s", notice.getClientServiceId(), notice.getClientServiceIp());
                logger.info("Receiving Service: \u3010{}\u3011, Request Log Report\uff0cLogging Content\uff1a{}", (Object)serviceInfo, (Object)(this.loggingAdminFactoryBean.isFormatConsoleLogJson() ? JsonUtil.beautifyJson((Object)notice.getLoggers()) : JSON.toJSONString((Object)notice.getLoggers())));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == LoggingEndpoint.class;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == ReportLogEvent.class;
    }

    public int getOrder() {
        return 0;
    }
}

