/*
 * Decompiled with CFR 0.152.
 */
package org.minbox.framework.logging.admin.listener;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.minbox.framework.logging.admin.LoggingAdminFactoryBean;
import org.minbox.framework.logging.admin.endpoint.LoggingEndpoint;
import org.minbox.framework.logging.admin.event.ReportLogEvent;
import org.minbox.framework.logging.admin.storage.LoggingStorage;
import org.minbox.framework.logging.core.GlobalLog;
import org.minbox.framework.logging.core.LoggingClientNotice;
import org.minbox.framework.logging.core.MinBoxLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ReportLogStorageListener
implements SmartApplicationListener {
    public static final String BEAN_NAME = "reportLogStorageListener";
    static Logger logger = LoggerFactory.getLogger(ReportLogStorageListener.class);
    ConcurrentMap<String, String> SERVICE_DETAIL_IDS = new ConcurrentHashMap<String, String>();
    private LoggingStorage loggingStorage;

    public ReportLogStorageListener(LoggingAdminFactoryBean adminFactoryBean) {
        Assert.notNull((Object)adminFactoryBean, (String)"[LoggingAdminFactoryBean] Can't be null.");
        this.loggingStorage = adminFactoryBean.getLoggingStorage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void onApplicationEvent(ApplicationEvent event) {
        try {
            logger.debug("Starting Storage Report Request Logs.");
            ReportLogEvent reportLogEvent = (ReportLogEvent)event;
            LoggingClientNotice notice = reportLogEvent.getLogClientNotice();
            String serviceDetail = this.formatServiceDetailID(notice.getClientServiceId(), notice.getClientServiceIp(), notice.getClientServicePort());
            String serviceDetailId = (String)this.SERVICE_DETAIL_IDS.get(serviceDetail);
            if (ObjectUtils.isEmpty((Object)serviceDetailId)) {
                serviceDetailId = this.loggingStorage.selectServiceDetailId(notice.getClientServiceId(), notice.getClientServiceIp(), notice.getClientServicePort());
                if (ObjectUtils.isEmpty((Object)serviceDetailId)) {
                    serviceDetailId = this.loggingStorage.insertServiceDetail(notice.getClientServiceId(), notice.getClientServiceIp(), notice.getClientServicePort());
                }
                if (!ObjectUtils.isEmpty((Object)serviceDetailId)) {
                    this.SERVICE_DETAIL_IDS.put(serviceDetail, serviceDetailId);
                }
            }
            if (!ObjectUtils.isEmpty((Object)notice.getLoggers())) {
                for (MinBoxLog log : notice.getLoggers()) {
                    String requestLogId = this.loggingStorage.insertLog(serviceDetailId, log);
                    this.saveGlobalLogs(requestLogId, log.getGlobalLogs());
                }
            }
            this.loggingStorage.updateLastReportTime(serviceDetailId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            logger.debug("Storage Report Request Logs Complete.");
        }
    }

    private void saveGlobalLogs(String requestLogId, List<GlobalLog> globalLogs) {
        if (!ObjectUtils.isEmpty(globalLogs) && !ObjectUtils.isEmpty((Object)requestLogId)) {
            globalLogs.forEach(globalLog -> {
                try {
                    this.loggingStorage.insertGlobalLog(requestLogId, (GlobalLog)globalLog);
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    String formatServiceDetailID(String serviceId, String serviceIp, Integer servicePort) {
        Assert.notNull((Object)serviceId, (String)"Service Id Is Required.");
        Assert.notNull((Object)serviceIp, (String)"Service Ip Is Required.");
        Assert.notNull((Object)servicePort, (String)"Service Port Is Required.");
        return String.format("%s-%s:%d", serviceId, serviceIp, servicePort);
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == ReportLogEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return sourceType == LoggingEndpoint.class;
    }

    public int getOrder() {
        return 1;
    }
}

