/*
 * Decompiled with CFR 0.152.
 */
package com.artemis.io;

import com.artemis.io.SaveFileFormat;
import com.artemis.utils.reflect.ClassReflection;
import com.artemis.utils.reflect.ReflectionException;
import com.esotericsoftware.jsonbeans.Json;
import com.esotericsoftware.jsonbeans.JsonSerializer;
import com.esotericsoftware.jsonbeans.JsonValue;
import java.util.Map;

public class ComponentLookupSerializer
implements JsonSerializer<SaveFileFormat.ComponentIdentifiers> {
    public void write(Json json, SaveFileFormat.ComponentIdentifiers ci, Class knownType) {
        json.writeObjectStart();
        for (Map.Entry entry : ci.typeToName.entrySet()) {
            json.writeValue(((Class)entry.getKey()).getName(), entry.getValue());
        }
        json.writeObjectEnd();
    }

    public SaveFileFormat.ComponentIdentifiers read(Json json, JsonValue jsonData, Class type) {
        SaveFileFormat.ComponentIdentifiers ci = new SaveFileFormat.ComponentIdentifiers();
        JsonValue component = jsonData.child;
        try {
            while (component != null) {
                Class c = ClassReflection.forName((String)component.name());
                ci.typeToName.put(c, component.asString());
                component = component.next;
            }
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        ci.build();
        return ci;
    }
}

