/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mini2Dx.gettext.Utils;

public class TranslationEntry {
    private final List<String> translatorComments = new ArrayList<String>(2);
    private final List<String> extractedComments = new ArrayList<String>(2);
    private final List<String> flags = new ArrayList<String>(2);
    private final List<String> mergeComments = new ArrayList<String>(2);
    private String reference;
    private String context;
    private String id;
    private String idPlural;
    private final ArrayList<String> strings = new ArrayList(2);

    public void writeTo(PrintWriter printWriter) {
        for (String comment : this.translatorComments) {
            printWriter.println("# " + this.trimComment(comment));
        }
        for (String comment : this.extractedComments) {
            printWriter.println("#. " + this.trimComment(comment));
        }
        for (String comment : this.flags) {
            printWriter.println("#, " + this.trimComment(comment));
        }
        for (String comment : this.mergeComments) {
            printWriter.println("#| " + this.trimComment(comment));
        }
        if (this.reference != null && !this.reference.isEmpty()) {
            printWriter.println("#: " + this.trimComment(this.reference));
        }
        if (this.context != null && !this.context.isEmpty()) {
            printWriter.println("msgctxt \"" + this.context + "\"");
        }
        if (this.id != null && !this.id.isEmpty()) {
            printWriter.println("msgid \"" + Utils.escapeDoubleQuotes(this.id) + "\"");
        }
        if (this.idPlural != null && !this.idPlural.isEmpty()) {
            printWriter.println("msgid_plural \"" + Utils.escapeDoubleQuotes(this.idPlural) + "\"");
        }
        if (this.strings.isEmpty()) {
            if (this.idPlural != null && !this.idPlural.isEmpty()) {
                printWriter.println("msgstr[0] \"\"");
                printWriter.println("msgstr[1] \"\"");
                printWriter.println("msgstr[2] \"\"");
            } else {
                printWriter.println("msgstr \"\"");
            }
        } else if (this.strings.size() > 1) {
            for (int i = 0; i < this.strings.size(); ++i) {
                String str = this.strings.get(i);
                if (str == null) {
                    printWriter.println("msgstr[" + i + "] \"\"");
                    continue;
                }
                printWriter.println("msgstr[" + i + "] \"" + Utils.escapeDoubleQuotes(str) + "\"");
            }
            printWriter.println("msgid_plural \"" + Utils.escapeDoubleQuotes(this.idPlural) + "\"");
        } else {
            printWriter.println("msgstr \"" + Utils.escapeDoubleQuotes(this.strings.get(0)) + "\"");
        }
    }

    public List<String> getTranslatorComments() {
        return this.translatorComments;
    }

    public List<String> getExtractedComments() {
        return this.extractedComments;
    }

    public List<String> getFlags() {
        return this.flags;
    }

    public List<String> getMergeComments() {
        return this.mergeComments;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdPlural() {
        return this.idPlural;
    }

    public void setIdPlural(String idPlural) {
        this.idPlural = idPlural;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public void setString(int index, String str) {
        this.strings.ensureCapacity(index);
        while (index >= this.strings.size()) {
            this.strings.add(null);
        }
        this.strings.set(index, str);
    }

    private String trimComment(String str) {
        if (str.charAt(0) == ' ') {
            return str.substring(1);
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationEntry entry = (TranslationEntry)o;
        return Objects.equals(this.translatorComments, entry.translatorComments) && Objects.equals(this.extractedComments, entry.extractedComments) && Objects.equals(this.flags, entry.flags) && Objects.equals(this.mergeComments, entry.mergeComments) && Objects.equals(this.reference, entry.reference) && Objects.equals(this.context, entry.context) && Objects.equals(this.id, entry.id) && Objects.equals(this.idPlural, entry.idPlural) && Objects.equals(this.strings, entry.strings);
    }

    public int hashCode() {
        return Objects.hash(this.translatorComments, this.extractedComments, this.flags, this.mergeComments, this.reference, this.context, this.id, this.idPlural, this.strings);
    }

    public String toString() {
        return "TranslationEntry{translatorComments=" + this.translatorComments + ", extractedComments=" + this.extractedComments + ", flags=" + this.flags + ", mergeComments=" + this.mergeComments + ", reference='" + this.reference + '\'' + ", context='" + this.context + '\'' + ", id='" + this.id + '\'' + ", idPlural='" + this.idPlural + '\'' + ", strings=" + this.strings + '}';
    }
}

