/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.gettext;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mini2Dx.gettext.PoFile;
import org.mini2Dx.gettext.TranslationContext;
import org.mini2Dx.gettext.TranslationEntry;

public class TranslationMap {
    private final Locale locale;
    private final TranslationContext defaultContext = new TranslationContext();
    private final Map<String, TranslationContext> contexts = new HashMap<String, TranslationContext>();
    private final Map<String, MessageFormat> messageFormatsCache = new HashMap<String, MessageFormat>();

    public TranslationMap(Locale locale) {
        this.locale = locale;
    }

    public String tr(String sourceText) {
        return this.defaultContext.tr(sourceText);
    }

    public String tr(String sourceText, Object ... values) {
        return this.format(sourceText, this.tr(sourceText), values);
    }

    public String trc(String context, String sourceText) {
        TranslationContext translationContext = this.contexts.get(context);
        if (translationContext == null) {
            return sourceText;
        }
        return translationContext.tr(sourceText);
    }

    public String trc(String context, String sourceText, Object ... values) {
        return MessageFormat.format(TranslationMap.messageFormatSanitise(this.tr(sourceText)), values);
    }

    public String trn(String sourceText, String sourcePluralText, int n) {
        return this.defaultContext.trn(sourceText, sourcePluralText, n);
    }

    public String trn(String sourceText, String sourcePluralText, int n, Object ... values) {
        String id = sourcePluralText != null && !sourcePluralText.isEmpty() ? sourcePluralText + "-" + n : sourceText + "-" + n;
        return this.format(id, this.trn(sourceText, sourcePluralText, n), values);
    }

    public String trnc(String context, String sourceText, String sourcePluralText, int n) {
        TranslationContext translationContext = this.contexts.get(context);
        if (translationContext == null) {
            return sourceText;
        }
        return translationContext.trn(sourceText, sourcePluralText, n);
    }

    public String trnc(String context, String sourceText, String sourcePluralText, int n, Object ... values) {
        String id = sourcePluralText != null && !sourcePluralText.isEmpty() ? sourcePluralText + "-" + n : sourceText + "-" + n;
        return this.format(id, this.trnc(context, sourceText, sourcePluralText, n), values);
    }

    public TranslationEntry getEntry(String sourceText) {
        return this.getEntry(null, sourceText);
    }

    public TranslationEntry getEntry(String context, String sourceText) {
        TranslationContext translationContext;
        if (context == null || context.isEmpty()) {
            translationContext = this.defaultContext;
        } else {
            if (!this.contexts.containsKey(context)) {
                this.contexts.put(context, new TranslationContext());
            }
            translationContext = this.contexts.get(context);
        }
        return translationContext.getEntryBySingularForm(sourceText);
    }

    private String format(String id, String str, Object ... values) {
        if (!this.messageFormatsCache.containsKey(id)) {
            this.messageFormatsCache.put(id, new MessageFormat(TranslationMap.messageFormatSanitise(str), this.locale));
        }
        return this.messageFormatsCache.get(id).format(values, new StringBuffer(str.length() + (values == null ? 1 : values.length)), (FieldPosition)null).toString();
    }

    public void add(PoFile poFile) {
        if (poFile == null) {
            throw new NullPointerException("Null poFile reference");
        }
        for (TranslationEntry entry : poFile.getEntries()) {
            TranslationContext context;
            if (entry.getContext() != null && !entry.getContext().isEmpty()) {
                if (!this.contexts.containsKey(entry.getContext())) {
                    this.contexts.put(entry.getContext(), new TranslationContext());
                }
                context = this.contexts.get(entry.getContext());
            } else {
                context = this.defaultContext;
            }
            context.add(entry);
        }
    }

    public static String messageFormatSanitise(String str) {
        return str.replace("'", "''");
    }
}

