/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.assets;

import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import org.mini2Dx.core.exception.MdxException;

public class FallbackFileHandleResolver
implements FileHandleResolver {
    private Array<FileHandleResolver> resolvers;

    public FallbackFileHandleResolver(FileHandleResolver ... resolvers) {
        if (resolvers.length == 0) {
            throw new MdxException(FallbackFileHandleResolver.class.getSimpleName() + " requires at least 1 " + FileHandleResolver.class.getSimpleName());
        }
        this.resolvers = new Array(true, resolvers.length, FileHandleResolver.class);
        for (int i = 0; i < resolvers.length; ++i) {
            this.resolvers.add((Object)resolvers[i]);
        }
    }

    public FileHandle resolve(String fileName) {
        for (FileHandleResolver resolver : this.resolvers) {
            FileHandle result = resolver.resolve(fileName);
            if (result == null || !result.exists()) continue;
            return result;
        }
        return null;
    }
}

