/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.audio;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Deprecated
public class CrossFadingMusicLoop {
    private static final float ONE_SECOND_IN_NANOSECONDS = 1.0E9f;
    private final float crossfadeTime;
    private final float crossfadeDuration;
    private Music currentTrack;
    private Music nextTrack;
    private volatile boolean playing;
    private volatile float targetVolume = 1.0f;
    private float cursor;
    private long previousTimestamp;
    private ScheduledExecutorService scheduledExecutorService;

    public CrossFadingMusicLoop(FileHandle musicFile, float crossfadeTime, float crossfadeDuration) {
        this.currentTrack = Gdx.audio.newMusic(musicFile);
        this.nextTrack = Gdx.audio.newMusic(musicFile);
        this.crossfadeTime = crossfadeTime;
        this.crossfadeDuration = crossfadeDuration;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
    }

    public void update() {
        if (this.playing && !this.currentTrack.isPlaying()) {
            this.currentTrack.setVolume(this.targetVolume);
            this.currentTrack.play();
            this.previousTimestamp = System.nanoTime();
        }
        if (!this.playing) {
            if (this.currentTrack.isPlaying()) {
                this.currentTrack.stop();
                this.nextTrack.stop();
            }
            return;
        }
        long timestamp = System.nanoTime();
        this.cursor += (float)(timestamp - this.previousTimestamp) / 1.0E9f;
        this.previousTimestamp = timestamp;
        if (this.cursor < this.crossfadeTime) {
            this.currentTrack.setVolume(this.targetVolume);
        } else {
            this.fadeInNextTrack();
            this.fadeOutCurrentTrack();
        }
        if (this.cursor >= this.crossfadeTime + this.crossfadeDuration) {
            this.cursor -= this.crossfadeTime + this.crossfadeDuration;
            Music tmpTrack = this.currentTrack;
            this.currentTrack = this.nextTrack;
            this.nextTrack = tmpTrack;
        }
    }

    private void fadeInNextTrack() {
        float trackTargetVolume = MathUtils.clamp((float)((this.cursor - this.crossfadeTime) / this.crossfadeDuration), (float)0.0f, (float)this.targetVolume);
        this.nextTrack.setVolume(trackTargetVolume);
        if (!this.nextTrack.isPlaying() && this.playing) {
            this.nextTrack.play();
        }
    }

    private void fadeOutCurrentTrack() {
        float trackTargetVolume = MathUtils.clamp((float)(1.0f - (this.cursor - this.crossfadeTime) / this.crossfadeDuration), (float)0.0f, (float)this.targetVolume);
        this.currentTrack.setVolume(trackTargetVolume);
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        this.playing = false;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void dispose() {
        if (this.isPlaying()) {
            throw new RuntimeException("Cannot dispose of a music instance that is currently playing");
        }
        if (this.currentTrack.isPlaying()) {
            this.currentTrack.stop();
        }
        if (this.nextTrack.isPlaying()) {
            this.nextTrack.stop();
        }
        this.currentTrack.dispose();
        this.nextTrack.dispose();
        this.scheduledExecutorService.shutdown();
    }

    public void setVolume(float volume) {
        this.targetVolume = volume;
    }

    public void fadeOut(float duration) {
        long durationInMilliseconds = MathUtils.round((float)(duration * 1000.0f));
        for (long i = 0L; i < durationInMilliseconds; i += 50L) {
            float volume = MathUtils.clamp((float)(1.0f - Float.valueOf(i).floatValue() / Float.valueOf(durationInMilliseconds).floatValue()), (float)0.0f, (float)1.0f);
            this.scheduledExecutorService.schedule(new ScheduleFadeOut(volume), i, TimeUnit.MILLISECONDS);
        }
    }

    public void fadeOutAndStop(float duration) {
        this.fadeOut(duration - 0.05f);
        this.scheduledExecutorService.schedule(new ScheduleStop(), (long)MathUtils.round((float)(duration * 1000.0f)), TimeUnit.MILLISECONDS);
    }

    private class ScheduleFadeOut
    implements Runnable {
        private float volume;

        public ScheduleFadeOut(float volume) {
            this.volume = volume;
        }

        @Override
        public void run() {
            CrossFadingMusicLoop.this.targetVolume = this.volume;
        }
    }

    public class ScheduleStop
    implements Runnable {
        @Override
        public void run() {
            CrossFadingMusicLoop.this.stop();
        }
    }
}

