/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collisions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import org.mini2Dx.core.collisions.ConcurrentPointQuadTree;
import org.mini2Dx.core.collisions.QuadTree;
import org.mini2Dx.core.engine.geom.CollisionShape;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;

public class ConcurrentRegionQuadTree<T extends CollisionShape>
extends ConcurrentPointQuadTree<T> {
    private static final long serialVersionUID = 2344163859287984782L;

    public ConcurrentRegionQuadTree(int elementLimit, int mergeWatermark, float x, float y, float width, float height) {
        super(elementLimit, mergeWatermark, x, y, width, height);
    }

    public ConcurrentRegionQuadTree(int elementLimit, float x, float y, float width, float height) {
        super(elementLimit, x, y, width, height);
    }

    public ConcurrentRegionQuadTree(ConcurrentRegionQuadTree<T> parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
    }

    public ConcurrentRegionQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(minimumQuadWidth, minimumQuadHeight, elementLimitPerQuad, mergeWatermark, x, y, width, height);
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        tmp = g.getColor();
        g.setColor(ELEMENT_COLOR);
        for (CollisionShape element : this.elements) {
            g.drawRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
        this.lock.readLock().unlock();
        g.setColor(tmp);
    }

    @Override
    public void addAll(Array<T> elements) {
        if (elements == null || elements.size == 0) {
            return;
        }
        Array elementsWithinQuad = new Array();
        for (CollisionShape element : elements) {
            if (!this.contains(element.getShape()) && !this.intersects(element.getShape())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.clearTotalElementsCache();
        this.lock.writeLock().lock();
        if (this.topLeft != null) {
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
            for (int i = elementsWithinQuad.size - 1; i >= 0; --i) {
                CollisionShape element;
                element = (CollisionShape)elementsWithinQuad.get(i);
                if (this.topLeft.add(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.topRight.add(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.bottomLeft.add(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (!this.bottomRight.add(element)) continue;
                elementsWithinQuad.removeIndex(i);
            }
            this.lock.readLock().unlock();
            if (elementsWithinQuad.size == 0) {
                return;
            }
            this.lock.writeLock().lock();
        }
        this.elements.addAll(elementsWithinQuad);
        for (CollisionShape element : elementsWithinQuad) {
            element.addPostionChangeListener(this);
        }
        int totalElements = this.elements.size;
        this.lock.writeLock().unlock();
        if (totalElements > this.elementLimitPerQuad && this.getWidth() >= 2.0f && this.getHeight() >= 2.0f) {
            this.subdivide();
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects(element.getShape()) && !this.contains(element.getShape())) {
            return false;
        }
        this.clearTotalElementsCache();
        return this.addElement(element);
    }

    @Override
    protected boolean addElement(T element) {
        this.lock.writeLock().lock();
        if (this.topLeft != null) {
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
            boolean result = this.addElementToChild(element);
            if (result) {
                return true;
            }
            this.lock.writeLock().lock();
        }
        this.elements.add(element);
        element.addPostionChangeListener(this);
        if (this.elements.size > this.elementLimitPerQuad && this.getWidth() >= 2.0f && this.getHeight() >= 2.0f) {
            this.subdivide();
        }
        this.lock.writeLock().unlock();
        return true;
    }

    @Override
    protected boolean addElementToChild(T element) {
        Shape shape = element.getShape();
        if (this.topLeft.contains(shape)) {
            boolean result = this.topLeft.add(element);
            this.lock.readLock().unlock();
            return result;
        }
        if (this.topRight.contains(shape)) {
            boolean result = this.topRight.add(element);
            this.lock.readLock().unlock();
            return result;
        }
        if (this.bottomLeft.contains(shape)) {
            boolean result = this.bottomLeft.add(element);
            this.lock.readLock().unlock();
            return result;
        }
        if (this.bottomRight.contains(shape)) {
            boolean result = this.bottomRight.add(element);
            this.lock.readLock().unlock();
            return result;
        }
        this.lock.readLock().unlock();
        return false;
    }

    @Override
    protected void subdivide() {
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            this.lock.readLock().unlock();
            return;
        }
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        if (this.topLeft != null) {
            this.lock.writeLock().unlock();
            return;
        }
        float halfWidth = this.getWidth() / 2.0f;
        float halfHeight = this.getHeight() / 2.0f;
        this.topLeft = new ConcurrentRegionQuadTree<T>(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = new ConcurrentRegionQuadTree<T>(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = new ConcurrentRegionQuadTree<T>(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = new ConcurrentRegionQuadTree<T>(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            this.lock.readLock().lock();
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (!this.addElementToChild((T)element)) continue;
            this.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this);
        }
        this.lock.writeLock().unlock();
    }

    @Override
    public void removeAll(Array<T> elementsToRemove) {
        if (elementsToRemove == null || elementsToRemove.size == 0) {
            return;
        }
        this.clearTotalElementsCache();
        Array elementsWithinQuad = new Array();
        for (CollisionShape element : elementsToRemove) {
            if (!this.contains(element.getShape()) && !this.intersects(element.getShape())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            for (int i = elementsWithinQuad.size - 1; i >= 0; --i) {
                CollisionShape element;
                element = (CollisionShape)elementsWithinQuad.get(i);
                if (this.topLeft.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.topRight.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.bottomLeft.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (!this.bottomRight.remove(element)) continue;
                elementsWithinQuad.removeIndex(i);
            }
        }
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        this.elements.removeAll(elementsWithinQuad, false);
        this.lock.writeLock().unlock();
        for (CollisionShape element : elementsWithinQuad) {
            element.removePositionChangeListener(this);
        }
        if (this.parent == null) {
            return;
        }
        if (this.parent.isMergable()) {
            this.parent.merge();
        }
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects(element.getShape()) && !this.contains(element.getShape())) {
            return false;
        }
        this.clearTotalElementsCache();
        return this.removeElement(element, true);
    }

    @Override
    protected boolean removeElement(T element, boolean topDownInvocation) {
        boolean result;
        this.lock.writeLock().lock();
        if (this.topLeft != null) {
            this.lock.readLock().lock();
            this.lock.writeLock().unlock();
            result = this.removeElementFromChild(element);
            if (result) {
                return true;
            }
            this.lock.writeLock().lock();
        }
        result = this.elements.removeValue(element, false);
        this.lock.writeLock().unlock();
        element.removePositionChangeListener(this);
        if (this.parent == null) {
            return result;
        }
        if (result && this.parent.isMergable()) {
            if (!topDownInvocation) {
                this.parent.lock.readLock().lock();
            }
            this.parent.merge();
            if (!topDownInvocation) {
                this.parent.lock.readLock().unlock();
            }
        }
        return result;
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            if (this.topLeft.contains(area) || this.topLeft.intersects(area)) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (this.topRight.contains(area) || this.topRight.intersects(area)) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (this.bottomLeft.contains(area) || this.bottomLeft.intersects(area)) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.bottomRight.contains(area) || this.bottomRight.intersects(area)) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (element == null || !area.contains(element.getShape()) && !area.intersects(element.getShape())) continue;
            result.add((Object)element);
        }
        this.lock.readLock().unlock();
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            if (this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (element == null || !element.contains(point)) continue;
            result.add((Object)element);
        }
        this.lock.readLock().unlock();
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            if (this.topLeft.intersects(lineSegment) || this.topLeft.contains(lineSegment.getPointA()) || this.topLeft.contains(lineSegment.getPointB())) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.topRight.intersects(lineSegment) || this.topRight.contains(lineSegment.getPointA()) || this.topRight.contains(lineSegment.getPointB())) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomLeft.intersects(lineSegment) || this.bottomLeft.contains(lineSegment.getPointA()) || this.bottomLeft.contains(lineSegment.getPointB())) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomRight.intersects(lineSegment) || this.bottomRight.contains(lineSegment.getPointA()) || this.bottomRight.contains(lineSegment.getPointB())) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (element == null || !element.intersects(lineSegment)) continue;
            result.add((Object)element);
        }
        this.lock.readLock().unlock();
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            ((ConcurrentRegionQuadTree)this.topLeft).getElements(result);
            ((ConcurrentRegionQuadTree)this.topRight).getElements(result);
            ((ConcurrentRegionQuadTree)this.bottomLeft).getElements(result);
            ((ConcurrentRegionQuadTree)this.bottomRight).getElements(result);
        }
        result.addAll(this.elements);
        this.lock.readLock().unlock();
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        this.totalElementsCache = 0;
        this.lock.readLock().lock();
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        }
        this.totalElementsCache += this.elements.size;
        this.lock.readLock().unlock();
        return this.totalElementsCache;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains(moved.getShape())) {
            return;
        }
        this.removeElement(moved, false);
        for (QuadTree parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }
}

