/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collisions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import org.mini2Dx.core.collisions.QuadTree;
import org.mini2Dx.core.collisions.QuadWatermarkException;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;

public class PointQuadTree<T extends Positionable>
extends Rectangle
implements QuadTree<T> {
    public static final float DEFAULT_MINIMUM_QUAD_SIZE = 8.0f;
    public static Color QUAD_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    public static Color ELEMENT_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.5f);
    private static final long serialVersionUID = -2034928347848875105L;
    protected PointQuadTree<T> parent;
    protected PointQuadTree<T> topLeft;
    protected PointQuadTree<T> topRight;
    protected PointQuadTree<T> bottomLeft;
    protected PointQuadTree<T> bottomRight;
    protected Array<T> elements;
    protected final int elementLimitPerQuad;
    protected final int mergeWatermark;
    protected final float minimumQuadWidth;
    protected final float minimumQuadHeight;
    protected int totalElementsCache = -1;

    public PointQuadTree(int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        this(8.0f, 8.0f, elementLimitPerQuad, mergeWatermark, x, y, width, height);
    }

    public PointQuadTree(int elementLimitPerQuad, float x, float y, float width, float height) {
        this(elementLimitPerQuad, 0, x, y, width, height);
    }

    public PointQuadTree(PointQuadTree<T> parent, float x, float y, float width, float height) {
        this(parent.getMinimumQuadWidth(), parent.getMinimumQuadHeight(), parent.getElementLimitPerQuad(), parent.getMergeWatermark(), x, y, width, height);
        this.parent = parent;
    }

    public PointQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(x, y, width, height);
        if (mergeWatermark >= elementLimitPerQuad) {
            throw new QuadWatermarkException(elementLimitPerQuad, mergeWatermark);
        }
        this.elementLimitPerQuad = elementLimitPerQuad;
        this.mergeWatermark = mergeWatermark;
        this.minimumQuadWidth = minimumQuadWidth;
        this.minimumQuadHeight = minimumQuadHeight;
        this.elements = new Array(true, elementLimitPerQuad);
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawShape(this);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        tmp = g.getColor();
        g.setColor(ELEMENT_COLOR);
        for (Positionable element : this.elements) {
            g.fillRect(element.getX(), element.getY(), 1.0f, 1.0f);
        }
        g.setColor(tmp);
    }

    @Override
    public void addAll(Array<T> elementsToAdd) {
        if (elementsToAdd == null || elementsToAdd.size == 0) {
            return;
        }
        Array elementsWithinQuad = new Array();
        for (Positionable element : elementsToAdd) {
            if (!this.contains(element.getX(), element.getY())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            for (Positionable element : elementsWithinQuad) {
                this.addElementToChild(element);
            }
            return;
        }
        for (Positionable element : elementsWithinQuad) {
            this.elements.add((Object)element);
            element.addPostionChangeListener(this);
        }
        if (this.elements.size > this.elementLimitPerQuad && this.getWidth() * 0.5f >= this.minimumQuadWidth && this.getHeight() * 0.5f >= this.minimumQuadHeight) {
            this.subdivide();
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.contains(element.getX(), element.getY())) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            return this.addElementToChild(element);
        }
        return this.addElement(element);
    }

    protected boolean addElement(T element) {
        this.elements.add(element);
        element.addPostionChangeListener(this);
        if (this.elements.size > this.elementLimitPerQuad && this.getWidth() * 0.5f >= this.minimumQuadWidth && this.getHeight() * 0.5f >= this.minimumQuadHeight) {
            this.subdivide();
        }
        return true;
    }

    protected boolean addElementToChild(T element) {
        if (this.topLeft.add(element)) {
            return true;
        }
        if (this.topRight.add(element)) {
            return true;
        }
        if (this.bottomLeft.add(element)) {
            return true;
        }
        return this.bottomRight.add(element);
    }

    protected void subdivide() {
        if (this.topLeft != null) {
            return;
        }
        float halfWidth = this.getWidth() * 0.5f;
        float halfHeight = this.getHeight() * 0.5f;
        this.topLeft = new PointQuadTree<T>(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = new PointQuadTree<T>(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = new PointQuadTree<T>(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = new PointQuadTree<T>(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.removeIndex(i);
            element.removePositionChangeListener(this);
            this.addElementToChild(element);
        }
        this.elements = null;
    }

    protected boolean isMergable() {
        if (this.topLeft == null) {
            return false;
        }
        if (this.mergeWatermark <= 0) {
            return false;
        }
        int topLeftTotal = this.topLeft.getTotalElements();
        if (topLeftTotal >= this.mergeWatermark) {
            return false;
        }
        int topRightTotal = this.topRight.getTotalElements();
        if (topRightTotal >= this.mergeWatermark) {
            return false;
        }
        int bottomLeftTotal = this.bottomLeft.getTotalElements();
        if (bottomLeftTotal >= this.mergeWatermark) {
            return false;
        }
        int bottomRightTotal = this.bottomRight.getTotalElements();
        if (bottomRightTotal >= this.mergeWatermark) {
            return false;
        }
        return topLeftTotal + topRightTotal + bottomLeftTotal + bottomRightTotal < this.mergeWatermark;
    }

    protected void merge() {
        if (this.topLeft == null) {
            return;
        }
        this.elements = new Array(true, this.elementLimitPerQuad);
        this.topLeft.getElements(this.elements);
        this.topRight.getElements(this.elements);
        this.bottomLeft.getElements(this.elements);
        this.bottomRight.getElements(this.elements);
        for (Positionable element : this.elements) {
            this.topLeft.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.topLeft);
            this.topRight.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.topRight);
            this.bottomLeft.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.bottomLeft);
            this.bottomRight.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.bottomRight);
            element.addPostionChangeListener(this);
        }
        this.topLeft = null;
        this.topRight = null;
        this.bottomLeft = null;
        this.bottomRight = null;
    }

    @Override
    public void removeAll(Array<T> elementsToRemove) {
        if (elementsToRemove == null || elementsToRemove.size == 0) {
            return;
        }
        Array elementsWithinQuad = new Array();
        for (Positionable element : elementsToRemove) {
            if (!this.contains(element.getX(), element.getY())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            for (Positionable element : elementsWithinQuad) {
                this.removeElementFromChild(element);
            }
        }
        if (this.elements == null) {
            return;
        }
        this.elements.removeAll(elementsWithinQuad, false);
        for (Positionable element : elementsWithinQuad) {
            element.removePositionChangeListener(this);
        }
        if (this.parent == null) {
            return;
        }
        if (this.parent.isMergable()) {
            this.parent.merge();
        }
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.contains(element.getX(), element.getY())) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            return this.removeElementFromChild(element);
        }
        return this.removeElement(element);
    }

    public void clear() {
        if (this.topLeft != null) {
            this.topLeft.clear();
            this.topRight.clear();
            this.bottomLeft.clear();
            this.bottomRight.clear();
            this.topLeft = null;
            this.topRight = null;
            this.bottomLeft = null;
            this.bottomRight = null;
        } else {
            this.elements.clear();
        }
    }

    protected boolean removeElementFromChild(T element) {
        if (this.topLeft.remove(element)) {
            return true;
        }
        if (this.topRight.remove(element)) {
            return true;
        }
        if (this.bottomLeft.remove(element)) {
            return true;
        }
        return this.bottomRight.remove(element);
    }

    protected boolean removeElement(T element) {
        boolean result = this.elements.removeValue(element, false);
        element.removePositionChangeListener(this);
        if (this.parent == null) {
            return result;
        }
        if (result && this.parent.isMergable()) {
            this.parent.merge();
        }
        return result;
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        if (this.topLeft != null) {
            this.topLeft.getElementsWithinArea(result, area);
            this.topRight.getElementsWithinArea(result, area);
            this.bottomLeft.getElementsWithinArea(result, area);
            this.bottomRight.getElementsWithinArea(result, area);
        } else {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Positionable element = (Positionable)this.elements.get(i);
                if (element == null || !area.contains(element.getX(), element.getY())) continue;
                result.add((Object)element);
            }
        }
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        if (this.topLeft != null) {
            if (this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        } else {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Positionable element = (Positionable)this.elements.get(i);
                if (element == null || element.getX() != point.x || element.getY() != point.y) continue;
                result.add((Object)element);
            }
        }
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        if (this.topLeft != null) {
            if (this.topLeft.intersects(lineSegment) || this.topLeft.contains(lineSegment.getPointA()) || this.topLeft.contains(lineSegment.getPointB())) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.topRight.intersects(lineSegment) || this.topRight.contains(lineSegment.getPointA()) || this.topRight.contains(lineSegment.getPointB())) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomLeft.intersects(lineSegment) || this.bottomLeft.contains(lineSegment.getPointA()) || this.bottomLeft.contains(lineSegment.getPointB())) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomRight.intersects(lineSegment) || this.bottomRight.contains(lineSegment.getPointA()) || this.bottomRight.contains(lineSegment.getPointB())) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        } else {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Positionable element = (Positionable)this.elements.get(i);
                if (element == null || !lineSegment.contains(element.getX(), element.getY())) continue;
                result.add((Object)element);
            }
        }
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        if (this.topLeft != null) {
            this.topLeft.getElements(result);
            this.topRight.getElements(result);
            this.bottomLeft.getElements(result);
            this.bottomRight.getElements(result);
        } else {
            result.addAll(this.elements);
        }
    }

    @Override
    public int getTotalQuads() {
        if (this.topLeft != null) {
            int result = this.topLeft.getTotalQuads();
            result += this.topRight.getTotalQuads();
            result += this.bottomLeft.getTotalQuads();
            return result += this.bottomRight.getTotalQuads();
        }
        return 1;
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        } else {
            this.totalElementsCache = this.elements.size;
        }
        return this.totalElementsCache;
    }

    protected void clearTotalElementsCache() {
        this.totalElementsCache = -1;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains(moved.getX(), moved.getY())) {
            return;
        }
        this.removeElement(moved);
        for (QuadTree<T> parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }

    @Override
    public QuadTree<T> getParent() {
        return this.parent;
    }

    public int getElementLimitPerQuad() {
        return this.elementLimitPerQuad;
    }

    public int getMergeWatermark() {
        return this.mergeWatermark;
    }

    public boolean hasChildQuads() {
        return this.topLeft != null;
    }

    @Override
    public float getMinimumQuadWidth() {
        return this.minimumQuadWidth;
    }

    @Override
    public float getMinimumQuadHeight() {
        return this.minimumQuadHeight;
    }
}

