/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collisions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import org.mini2Dx.core.collisions.PointQuadTree;
import org.mini2Dx.core.collisions.QuadTree;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.engine.geom.CollisionShape;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;

public class RegionQuadTree<T extends CollisionShape>
extends PointQuadTree<T> {
    private static final long serialVersionUID = -2417612178966065600L;

    public RegionQuadTree(int elementLimit, int mergeWatermark, float x, float y, float width, float height) {
        super(elementLimit, mergeWatermark, x, y, width, height);
    }

    public RegionQuadTree(int elementLimit, float x, float y, float width, float height) {
        super(elementLimit, x, y, width, height);
    }

    public RegionQuadTree(RegionQuadTree<T> parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
    }

    public RegionQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(minimumQuadWidth, minimumQuadHeight, elementLimitPerQuad, mergeWatermark, x, y, width, height);
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        tmp = g.getColor();
        g.setColor(ELEMENT_COLOR);
        for (CollisionShape element : this.elements) {
            g.drawRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
        g.setColor(tmp);
    }

    @Override
    public void addAll(Array<T> elementsToAdd) {
        if (elementsToAdd == null || elementsToAdd.size == 0) {
            return;
        }
        this.clearTotalElementsCache();
        Array elementsWithinQuad = new Array();
        for (CollisionShape element : elementsToAdd) {
            if (!this.contains(element.getShape()) && !this.intersects(element.getShape())) continue;
            elementsWithinQuad.add((Object)element);
        }
        for (CollisionShape element : elementsWithinQuad) {
            if (this.topLeft == null) {
                this.addElement(element);
                continue;
            }
            if (this.addElementToChild((T)element)) continue;
            this.addElement(element);
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects(element.getShape()) && !this.contains(element.getShape())) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.topLeft == null) {
            return this.addElement(element);
        }
        if (this.addElementToChild(element)) {
            return true;
        }
        return this.addElement(element);
    }

    @Override
    protected boolean addElementToChild(T element) {
        Shape shape = element.getShape();
        if (this.topLeft.contains(shape)) {
            return this.topLeft.add(element);
        }
        if (this.topRight.contains(shape)) {
            return this.topRight.add(element);
        }
        if (this.bottomLeft.contains(shape)) {
            return this.bottomLeft.add(element);
        }
        if (this.bottomRight.contains(shape)) {
            return this.bottomRight.add(element);
        }
        return false;
    }

    @Override
    protected void subdivide() {
        if (this.topLeft != null) {
            return;
        }
        float halfWidth = this.getWidth() / 2.0f;
        float halfHeight = this.getHeight() / 2.0f;
        this.topLeft = new RegionQuadTree<T>(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = new RegionQuadTree<T>(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = new RegionQuadTree<T>(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = new RegionQuadTree<T>(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            if (!this.addElementToChild((T)((CollisionShape)this.elements.get(i)))) continue;
            this.removeElement((Positionable)this.elements.get(i));
        }
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects(element.getShape()) && !this.contains(element.getShape())) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.removeElement(element)) {
            return true;
        }
        if (this.topLeft == null) {
            return false;
        }
        return this.removeElementFromChild(element);
    }

    @Override
    public void clear() {
        if (this.topLeft != null) {
            this.topLeft.clear();
            this.topRight.clear();
            this.bottomLeft.clear();
            this.bottomRight.clear();
            this.topLeft = null;
            this.topRight = null;
            this.bottomLeft = null;
            this.bottomRight = null;
        }
        this.elements.clear();
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        if (this.topLeft != null) {
            if (this.topLeft.contains(area) || this.topLeft.intersects(area)) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (this.topRight.contains(area) || this.topRight.intersects(area)) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (this.bottomLeft.contains(area) || this.bottomLeft.intersects(area)) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.bottomRight.contains(area) || this.bottomRight.intersects(area)) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (element == null || !area.contains(element.getShape()) && !area.intersects(element.getShape())) continue;
            result.add((Object)element);
        }
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        if (this.topLeft != null) {
            if (this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (element == null || !element.contains(point)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        if (this.topLeft != null) {
            if (this.topLeft.intersects(lineSegment) || this.topLeft.contains(lineSegment.getPointA()) || this.topLeft.contains(lineSegment.getPointB())) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.topRight.intersects(lineSegment) || this.topRight.contains(lineSegment.getPointA()) || this.topRight.contains(lineSegment.getPointB())) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomLeft.intersects(lineSegment) || this.bottomLeft.contains(lineSegment.getPointA()) || this.bottomLeft.contains(lineSegment.getPointB())) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomRight.intersects(lineSegment) || this.bottomRight.contains(lineSegment.getPointA()) || this.bottomRight.contains(lineSegment.getPointB())) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            CollisionShape element = (CollisionShape)this.elements.get(i);
            if (element == null || !element.intersects(lineSegment)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        if (this.topLeft != null) {
            ((RegionQuadTree)this.topLeft).getElements(result);
            ((RegionQuadTree)this.topRight).getElements(result);
            ((RegionQuadTree)this.bottomLeft).getElements(result);
            ((RegionQuadTree)this.bottomRight).getElements(result);
        }
        result.addAll(this.elements);
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        this.totalElementsCache = 0;
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        }
        this.totalElementsCache += this.elements.size;
        return this.totalElementsCache;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains(moved.getShape())) {
            return;
        }
        this.removeElement(moved);
        for (QuadTree parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }
}

