/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.controller.ControllerType;
import org.mini2Dx.core.controller.PS4Controller;
import org.mini2Dx.core.controller.Xbox360Controller;
import org.mini2Dx.core.controller.XboxOneController;
import org.mini2Dx.core.controller.deadzone.DeadZone;
import org.mini2Dx.core.controller.ps4.MacPS4Controller;
import org.mini2Dx.core.controller.ps4.WindowsPS4Controller;
import org.mini2Dx.core.controller.xbox360.LinuxXbox360Controller;
import org.mini2Dx.core.controller.xbox360.MacXbox360Controller;
import org.mini2Dx.core.controller.xbox360.WindowsXbox360Controller;
import org.mini2Dx.core.controller.xboxone.LinuxXboxOneController;
import org.mini2Dx.core.controller.xboxone.MacXboxOneController;
import org.mini2Dx.core.controller.xboxone.WindowsXboxOneController;
import org.mini2Dx.core.exception.ControllerPlatformException;

public class ControllerMapping {
    private static final String LOGGING_TAG = ControllerMapping.class.getSimpleName();

    public static PS4Controller ps4(Controller controller) throws ControllerPlatformException {
        return ControllerMapping.ps4(controller, null, null);
    }

    public static PS4Controller ps4(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) throws ControllerPlatformException {
        switch (Mdx.os) {
            case WINDOWS: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new WindowsPS4Controller(controller);
                }
                return new WindowsPS4Controller(controller, leftStickDeadZone, rightStickDeadZone);
            }
            case MAC: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new MacPS4Controller(controller);
                }
                return new MacPS4Controller(controller, leftStickDeadZone, rightStickDeadZone);
            }
            case UNIX: {
                return null;
            }
        }
        throw new ControllerPlatformException(ControllerType.XBOX_360, Mdx.os);
    }

    public static Xbox360Controller xbox360(Controller controller) throws ControllerPlatformException {
        return ControllerMapping.xbox360(controller, null, null);
    }

    public static Xbox360Controller xbox360(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) throws ControllerPlatformException {
        switch (Mdx.os) {
            case WINDOWS: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new WindowsXbox360Controller(controller);
                }
                return new WindowsXbox360Controller(controller, leftStickDeadZone, rightStickDeadZone);
            }
            case MAC: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new MacXbox360Controller(controller);
                }
                return new MacXbox360Controller(controller, leftStickDeadZone, rightStickDeadZone);
            }
            case UNIX: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new LinuxXbox360Controller(controller);
                }
                return new LinuxXbox360Controller(controller, leftStickDeadZone, rightStickDeadZone);
            }
        }
        throw new ControllerPlatformException(ControllerType.XBOX_360, Mdx.os);
    }

    public static XboxOneController xboxOne(Controller controller) throws ControllerPlatformException {
        return ControllerMapping.xboxOne(controller, null, null);
    }

    public static XboxOneController xboxOne(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) throws ControllerPlatformException {
        switch (Mdx.os) {
            case WINDOWS: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new WindowsXboxOneController(controller);
                }
                return new WindowsXboxOneController(controller, leftStickDeadZone, rightStickDeadZone);
            }
            case MAC: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new MacXboxOneController(controller);
                }
                return new MacXboxOneController(controller, leftStickDeadZone, rightStickDeadZone);
            }
            case UNIX: {
                if (leftStickDeadZone == null || rightStickDeadZone == null) {
                    return new LinuxXboxOneController(controller);
                }
                return new LinuxXboxOneController(controller, leftStickDeadZone, rightStickDeadZone);
            }
        }
        throw new ControllerPlatformException(ControllerType.XBOX_ONE, Mdx.os);
    }

    public static ControllerType getControllerType(Controller controller) {
        String controllerName = controller.getName();
        String lowercaseControllerName = controllerName.toLowerCase();
        if (lowercaseControllerName.contains("xbox one")) {
            return ControllerType.XBOX_ONE;
        }
        if (lowercaseControllerName.contains("360")) {
            return ControllerType.XBOX_360;
        }
        switch (Mdx.os) {
            case WINDOWS: {
                if (lowercaseControllerName.equals(PS4Controller.WINDOWS_ID)) {
                    return ControllerType.PS4;
                }
                if (!lowercaseControllerName.equals(PS4Controller.MAC_ID)) break;
                return ControllerType.PS4;
            }
            case MAC: {
                if (!lowercaseControllerName.equals(PS4Controller.MAC_ID)) break;
                return ControllerType.PS4;
            }
            case UNIX: {
                break;
            }
        }
        Gdx.app.log(LOGGING_TAG, "Could not find controller mappings for " + controller.getName());
        return ControllerType.UNKNOWN;
    }
}

