/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.utils.Array;
import org.mini2Dx.core.controller.ControllerType;
import org.mini2Dx.core.controller.MdxController;
import org.mini2Dx.core.controller.button.Xbox360Button;
import org.mini2Dx.core.controller.deadzone.DeadZone;
import org.mini2Dx.core.controller.deadzone.NoopDeadZone;
import org.mini2Dx.core.controller.deadzone.RadialDeadZone;
import org.mini2Dx.core.controller.xbox360.Xbox360ControllerListener;

public abstract class Xbox360Controller
implements MdxController<Xbox360ControllerListener> {
    public static final String ID = "360";
    private final Controller controller;
    private final Array<Xbox360ControllerListener> listeners = new Array(true, 2);
    private DeadZone leftStickDeadZone;
    private DeadZone rightStickDeadZone;
    private DeadZone leftTriggerDeadZone;
    private DeadZone rightTriggerDeadZone;
    private boolean leftTrigger;
    private boolean rightTrigger;

    public Xbox360Controller(Controller controller) {
        this(controller, new NoopDeadZone(), new NoopDeadZone());
    }

    public Xbox360Controller(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        this.controller = controller;
        this.leftStickDeadZone = leftStickDeadZone;
        this.rightStickDeadZone = rightStickDeadZone;
        this.leftTriggerDeadZone = new RadialDeadZone();
        this.rightTriggerDeadZone = new RadialDeadZone();
        controller.addListener((ControllerListener)this);
    }

    protected boolean notifyDisconnected() {
        for (Xbox360ControllerListener listener : this.listeners) {
            listener.disconnected(this);
        }
        return false;
    }

    protected boolean notifyButtonDown(Xbox360Button button) {
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.buttonDown(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyButtonUp(Xbox360Button button) {
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.buttonUp(this, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftTriggerMoved(float value) {
        this.leftTriggerDeadZone.updateY(value);
        if (this.leftTriggerDeadZone.getY() >= 0.5f && !this.leftTrigger) {
            this.notifyButtonDown(Xbox360Button.LEFT_TRIGGER);
            this.leftTrigger = true;
        } else if (this.leftTriggerDeadZone.getY() < 0.5f && this.leftTrigger) {
            this.notifyButtonUp(Xbox360Button.LEFT_TRIGGER);
            this.leftTrigger = false;
        }
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.leftTriggerMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightTriggerMoved(float value) {
        this.rightTriggerDeadZone.updateY(value);
        if (this.rightTriggerDeadZone.getY() >= 0.5f && !this.rightTrigger) {
            this.notifyButtonDown(Xbox360Button.RIGHT_TRIGGER);
            this.rightTrigger = true;
        } else if (this.rightTriggerDeadZone.getY() < 0.5f && this.rightTrigger) {
            this.notifyButtonUp(Xbox360Button.RIGHT_TRIGGER);
            this.rightTrigger = false;
        }
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.rightTriggerMoved(this, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickXMoved(float value) {
        this.leftStickDeadZone.updateX(value);
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.leftStickXMoved(this, this.leftStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyLeftStickYMoved(float value) {
        this.leftStickDeadZone.updateY(value);
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.leftStickYMoved(this, this.leftStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickXMoved(float value) {
        this.rightStickDeadZone.updateX(value);
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.rightStickXMoved(this, this.rightStickDeadZone.getX())) continue;
            return true;
        }
        return false;
    }

    protected boolean notifyRightStickYMoved(float value) {
        this.rightStickDeadZone.updateY(value);
        for (Xbox360ControllerListener listener : this.listeners) {
            if (!listener.rightStickYMoved(this, this.rightStickDeadZone.getY())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addListener(int index, Xbox360ControllerListener listener) {
        this.listeners.insert(index, (Object)listener);
    }

    @Override
    public void addListener(Xbox360ControllerListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(int index) {
        this.listeners.removeIndex(index);
    }

    @Override
    public void removeListener(Xbox360ControllerListener listener) {
        this.listeners.removeValue((Object)listener, false);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public Xbox360ControllerListener getListener(int index) {
        return (Xbox360ControllerListener)this.listeners.get(index);
    }

    @Override
    public int getTotalListeners() {
        return this.listeners.size;
    }

    @Override
    public ControllerType getControllerType() {
        return ControllerType.XBOX_360;
    }

    public DeadZone getLeftStickDeadZone() {
        return this.leftStickDeadZone;
    }

    public void setLeftStickDeadZone(DeadZone leftStickDeadZone) {
        this.leftStickDeadZone = leftStickDeadZone;
    }

    public DeadZone getRightStickDeadZone() {
        return this.rightStickDeadZone;
    }

    public void setRightStickDeadZone(DeadZone rightStickDeadZone) {
        this.rightStickDeadZone = rightStickDeadZone;
    }

    public DeadZone getLeftTriggerDeadZone() {
        return this.leftTriggerDeadZone;
    }

    public void setLeftTriggerDeadZone(DeadZone leftTriggerDeadZone) {
        if (leftTriggerDeadZone == null) {
            leftTriggerDeadZone = new NoopDeadZone();
        }
        this.leftTriggerDeadZone = leftTriggerDeadZone;
    }

    public DeadZone getRightTriggerDeadZone() {
        return this.rightTriggerDeadZone;
    }

    public void setRightTriggerDeadZone(DeadZone rightTriggerDeadZone) {
        if (rightTriggerDeadZone == null) {
            rightTriggerDeadZone = new NoopDeadZone();
        }
        this.rightTriggerDeadZone = rightTriggerDeadZone;
    }
}

