/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.button;

import org.mini2Dx.core.controller.button.ControllerButton;

public enum Xbox360Button implements ControllerButton
{
    UP("xbox360-up"),
    DOWN("xbox360-down"),
    LEFT("xbox360-left"),
    RIGHT("xbox360-right"),
    START("xbox360-start"),
    BACK("xbox360-back"),
    GUIDE("xbox360-guide"),
    LEFT_STICK("xbox360-left-stick"),
    RIGHT_STICK("xbox360-right-stick"),
    LEFT_SHOULDER("xbox360-left-shoulder"),
    RIGHT_SHOULDER("xbox360-right-shoulder"),
    LEFT_TRIGGER("xbox360-left-trigger"),
    RIGHT_TRIGGER("xbox360-right-trigger"),
    A("xbox360-a"),
    B("xbox360-b"),
    X("xbox360-x"),
    Y("xbox360-y");

    private final String absoluteValue;

    private Xbox360Button(String absoluteValue) {
        this.absoluteValue = absoluteValue;
    }

    @Override
    public String getAbsoluteValue() {
        return this.absoluteValue;
    }

    @Override
    public boolean equals(ControllerButton controllerButton) {
        return this.absoluteValue.equals(controllerButton.getAbsoluteValue());
    }

    public static Xbox360Button fromAbsoluteValue(String value) {
        for (Xbox360Button button : Xbox360Button.values()) {
            if (!button.getAbsoluteValue().equals(value)) continue;
            return button;
        }
        return null;
    }
}

