/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.button;

import org.mini2Dx.core.controller.button.ControllerButton;

public enum XboxOneButton implements ControllerButton
{
    UP("xboxOne-up"),
    DOWN("xboxOne-down"),
    LEFT("xboxOne-left"),
    RIGHT("xboxOne-right"),
    MENU("xboxOne-menu"),
    VIEW("xboxOne-view"),
    HOME("xboxOne-home"),
    LEFT_STICK("xboxOne-left-stick"),
    RIGHT_STICK("xboxOne-right-stick"),
    LEFT_SHOULDER("xboxOne-left-shoulder"),
    RIGHT_SHOULDER("xboxOne-right-shoulder"),
    LEFT_TRIGGER("xboxOne-left-trigger"),
    RIGHT_TRIGGER("xboxOne-right-trigger"),
    A("xboxOne-a"),
    B("xboxOne-b"),
    X("xboxOne-x"),
    Y("xboxOne-y");

    private final String absoluteValue;

    private XboxOneButton(String absoluteValue) {
        this.absoluteValue = absoluteValue;
    }

    @Override
    public String getAbsoluteValue() {
        return this.absoluteValue;
    }

    @Override
    public boolean equals(ControllerButton controllerButton) {
        return this.absoluteValue.equals(controllerButton.getAbsoluteValue());
    }

    public static XboxOneButton fromAbsoluteValue(String value) {
        for (XboxOneButton button : XboxOneButton.values()) {
            if (!button.getAbsoluteValue().equals(value)) continue;
            return button;
        }
        return null;
    }
}

