/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.deadzone;

import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.controller.deadzone.DeadZone;

public class AxialDeadZone
implements DeadZone {
    private final Vector2 rawValues = new Vector2(0.0f, 0.0f);
    private final Vector2 filteredValues = new Vector2(0.0f, 0.0f);
    private float threshold = 0.25f;
    private boolean dirty = true;

    @Override
    public void updateX(float x) {
        this.rawValues.x = x;
        this.dirty = true;
    }

    @Override
    public void updateY(float y) {
        this.rawValues.y = y;
        this.dirty = true;
    }

    @Override
    public float getX() {
        this.dirtyCheck();
        return this.filteredValues.x;
    }

    @Override
    public float getY() {
        this.dirtyCheck();
        return this.filteredValues.y;
    }

    @Override
    public float getDeadZone() {
        return this.threshold;
    }

    @Override
    public void setDeadZone(float deadZone) {
        this.threshold = deadZone;
    }

    private void dirtyCheck() {
        if (!this.dirty) {
            return;
        }
        this.filteredValues.x = Math.abs(this.rawValues.x) < this.threshold ? 0.0f : this.rawValues.x;
        this.filteredValues.y = Math.abs(this.rawValues.y) < this.threshold ? 0.0f : this.rawValues.y;
        this.dirty = false;
    }

    @Override
    public DeadZone copy() {
        return new AxialDeadZone();
    }
}

