/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.deadzone;

import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.controller.deadzone.DeadZone;

public class ScaledRadialDeadZone
implements DeadZone {
    private final Vector2 rawValues = new Vector2(0.0f, 0.0f);
    private final Vector2 filteredValues = new Vector2(0.0f, 0.0f);
    private float thresholdRaw = 0.25f;
    private double thresholdCast = 0.25;
    private boolean dirty = true;

    @Override
    public void updateX(float x) {
        this.rawValues.x = x;
        this.dirty = true;
    }

    @Override
    public void updateY(float y) {
        this.rawValues.y = y;
        this.dirty = true;
    }

    @Override
    public float getX() {
        this.dirtyCheck();
        return this.filteredValues.x;
    }

    @Override
    public float getY() {
        this.dirtyCheck();
        return this.filteredValues.y;
    }

    @Override
    public float getDeadZone() {
        return this.thresholdRaw;
    }

    @Override
    public void setDeadZone(float deadZone) {
        this.thresholdRaw = deadZone;
        this.thresholdCast = this.thresholdRaw;
    }

    private void dirtyCheck() {
        if (!this.dirty) {
            return;
        }
        double magnitude = Math.sqrt(this.rawValues.x * this.rawValues.x + this.rawValues.y * this.rawValues.y);
        if (magnitude < this.thresholdCast) {
            this.filteredValues.x = 0.0f;
            this.filteredValues.y = 0.0f;
        } else {
            float magnitudeF = (float)magnitude;
            float rawX = this.rawValues.x;
            float rawY = this.rawValues.y;
            this.rawValues.nor();
            this.filteredValues.x = this.rawValues.x * (magnitudeF - this.thresholdRaw) / (1.0f - this.thresholdRaw);
            this.filteredValues.y = this.rawValues.y * (magnitudeF - this.thresholdRaw) / (1.0f - this.thresholdRaw);
            this.rawValues.set(rawX, rawY);
        }
        this.dirty = false;
    }

    @Override
    public DeadZone copy() {
        return new ScaledRadialDeadZone();
    }
}

