/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.ps4;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import org.mini2Dx.core.controller.PS4Controller;
import org.mini2Dx.core.controller.button.PS4Button;
import org.mini2Dx.core.controller.deadzone.DeadZone;
import org.mini2Dx.core.controller.deadzone.NoopDeadZone;

public class WindowsPS4Controller
extends PS4Controller {
    public static final int BUTTON_TRIANGLE = 3;
    public static final int BUTTON_SQUARE = 0;
    public static final int BUTTON_CIRCLE = 2;
    public static final int BUTTON_CROSS = 1;
    public static final int BUTTON_L1 = 4;
    public static final int BUTTON_L2 = 6;
    public static final int BUTTON_L3 = 10;
    public static final int BUTTON_R1 = 5;
    public static final int BUTTON_R2 = 7;
    public static final int BUTTON_R3 = 11;
    public static final int BUTTON_SHARE = 8;
    public static final int BUTTON_OPTIONS = 9;
    public static final int BUTTON_TOUCHPAD = 13;
    public static final int BUTTON_PS = 12;
    public static final int AXIS_LEFT_STICK_Y = 2;
    public static final int AXIS_LEFT_STICK_X = 3;
    public static final int AXIS_RIGHT_STICK_Y = 0;
    public static final int AXIS_RIGHT_STICK_X = 1;
    public static final int AXIS_L2 = 5;
    public static final int AXIS_R2 = 4;
    public static final int POV_DIRECTIONS = 0;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;

    public WindowsPS4Controller(Controller controller) {
        this(controller, new NoopDeadZone(), new NoopDeadZone());
    }

    public WindowsPS4Controller(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        super(controller, leftStickDeadZone, rightStickDeadZone);
    }

    public void connected(Controller controller) {
    }

    public void disconnected(Controller controller) {
        this.notifyDisconnected();
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case 2: {
                return this.notifyButtonDown(PS4Button.CIRCLE);
            }
            case 3: {
                return this.notifyButtonDown(PS4Button.TRIANGLE);
            }
            case 0: {
                return this.notifyButtonDown(PS4Button.SQUARE);
            }
            case 1: {
                return this.notifyButtonDown(PS4Button.CROSS);
            }
            case 4: {
                return this.notifyButtonDown(PS4Button.L1);
            }
            case 6: {
                return this.notifyButtonDown(PS4Button.L2);
            }
            case 10: {
                return this.notifyButtonDown(PS4Button.L3);
            }
            case 5: {
                return this.notifyButtonDown(PS4Button.R1);
            }
            case 7: {
                return this.notifyButtonDown(PS4Button.R2);
            }
            case 11: {
                return this.notifyButtonDown(PS4Button.R3);
            }
            case 8: {
                return this.notifyButtonDown(PS4Button.SHARE);
            }
            case 9: {
                return this.notifyButtonDown(PS4Button.OPTIONS);
            }
            case 13: {
                return this.notifyButtonDown(PS4Button.TOUCHPAD);
            }
            case 12: {
                return this.notifyButtonDown(PS4Button.PS);
            }
        }
        return false;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case 2: {
                return this.notifyButtonUp(PS4Button.CIRCLE);
            }
            case 3: {
                return this.notifyButtonUp(PS4Button.TRIANGLE);
            }
            case 0: {
                return this.notifyButtonUp(PS4Button.SQUARE);
            }
            case 1: {
                return this.notifyButtonUp(PS4Button.CROSS);
            }
            case 4: {
                return this.notifyButtonUp(PS4Button.L1);
            }
            case 6: {
                return this.notifyButtonUp(PS4Button.L2);
            }
            case 10: {
                return this.notifyButtonUp(PS4Button.L3);
            }
            case 5: {
                return this.notifyButtonUp(PS4Button.R1);
            }
            case 7: {
                return this.notifyButtonUp(PS4Button.R2);
            }
            case 11: {
                return this.notifyButtonUp(PS4Button.R3);
            }
            case 8: {
                return this.notifyButtonUp(PS4Button.SHARE);
            }
            case 9: {
                return this.notifyButtonUp(PS4Button.OPTIONS);
            }
            case 13: {
                return this.notifyButtonUp(PS4Button.TOUCHPAD);
            }
            case 12: {
                return this.notifyButtonUp(PS4Button.PS);
            }
        }
        return false;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        switch (axisCode) {
            case 3: {
                return this.notifyLeftStickXMoved(value);
            }
            case 2: {
                return this.notifyLeftStickYMoved(value);
            }
            case 1: {
                return this.notifyRightStickXMoved(value);
            }
            case 0: {
                return this.notifyRightStickYMoved(value);
            }
            case 5: {
                return this.notifyL2Moved(value);
            }
            case 4: {
                return this.notifyR2Moved(value);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        switch (povCode) {
            case 0: {
                switch (value) {
                    case center: {
                        if (this.up) {
                            this.notifyButtonUp(PS4Button.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(PS4Button.DOWN);
                            this.down = false;
                        }
                        if (this.left) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.left = false;
                        }
                        if (!this.right) return false;
                        this.notifyButtonUp(PS4Button.RIGHT);
                        this.right = false;
                        break;
                    }
                    case east: {
                        if (this.up) {
                            this.notifyButtonUp(PS4Button.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(PS4Button.DOWN);
                            this.down = false;
                        }
                        if (this.left) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.left = false;
                        }
                        if (this.right) return false;
                        this.right = true;
                        this.notifyButtonDown(PS4Button.RIGHT);
                        break;
                    }
                    case north: {
                        if (this.left) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.left = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(PS4Button.RIGHT);
                            this.right = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(PS4Button.DOWN);
                            this.down = false;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(PS4Button.UP);
                        break;
                    }
                    case northEast: {
                        if (this.left) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.left = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(PS4Button.DOWN);
                            this.down = false;
                        }
                        if (!this.right) {
                            this.notifyButtonDown(PS4Button.RIGHT);
                            this.right = true;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(PS4Button.UP);
                        break;
                    }
                    case northWest: {
                        if (this.right) {
                            this.notifyButtonUp(PS4Button.RIGHT);
                            this.right = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(PS4Button.DOWN);
                            this.down = false;
                        }
                        if (!this.left) {
                            this.notifyButtonDown(PS4Button.LEFT);
                            this.left = true;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(PS4Button.UP);
                        break;
                    }
                    case south: {
                        if (this.left) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.left = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(PS4Button.RIGHT);
                            this.right = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(PS4Button.UP);
                            this.up = false;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(PS4Button.DOWN);
                        this.down = true;
                        break;
                    }
                    case southEast: {
                        if (this.left) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.left = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(PS4Button.UP);
                            this.up = false;
                        }
                        if (!this.right) {
                            this.notifyButtonDown(PS4Button.RIGHT);
                            this.right = true;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(PS4Button.DOWN);
                        this.down = true;
                        break;
                    }
                    case southWest: {
                        if (this.right) {
                            this.notifyButtonUp(PS4Button.RIGHT);
                            this.right = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(PS4Button.UP);
                            this.up = false;
                        }
                        if (!this.left) {
                            this.notifyButtonDown(PS4Button.LEFT);
                            this.left = true;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(PS4Button.DOWN);
                        this.down = true;
                        break;
                    }
                    case west: {
                        if (this.up) {
                            this.notifyButtonUp(PS4Button.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(PS4Button.DOWN);
                            this.down = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(PS4Button.LEFT);
                            this.right = false;
                        }
                        if (this.left) return false;
                        this.left = true;
                        this.notifyButtonDown(PS4Button.LEFT);
                        break;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean accelerometerMoved(Controller controller, int accelerometerCode, Vector3 value) {
        return false;
    }
}

