/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.xbox360;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import org.mini2Dx.core.controller.Xbox360Controller;
import org.mini2Dx.core.controller.button.Xbox360Button;
import org.mini2Dx.core.controller.deadzone.DeadZone;

public class LinuxXbox360Controller
extends Xbox360Controller {
    public static final int BUTTON_UP = -1;
    public static final int BUTTON_DOWN = -2;
    public static final int BUTTON_LEFT = -3;
    public static final int BUTTON_RIGHT = -4;
    public static final int BUTTON_A = 0;
    public static final int BUTTON_B = 1;
    public static final int BUTTON_X = 2;
    public static final int BUTTON_Y = 3;
    public static final int BUTTON_LEFT_SHOULDER = 4;
    public static final int BUTTON_RIGHT_SHOULDER = 5;
    public static final int BUTTON_BACK = 6;
    public static final int BUTTON_START = 7;
    public static final int BUTTON_GUIDE = 8;
    public static final int BUTTON_LEFT_STICK = 9;
    public static final int BUTTON_RIGHT_STICK = 10;
    public static final int AXIS_LEFT_STICK_X = 0;
    public static final int AXIS_LEFT_STICK_Y = 1;
    public static final int AXIS_LEFT_TRIGGER = 2;
    public static final int AXIS_RIGHT_STICK_X = 3;
    public static final int AXIS_RIGHT_STICK_Y = 4;
    public static final int AXIS_RIGHT_TRIGGER = 5;

    public LinuxXbox360Controller(Controller controller) {
        super(controller);
    }

    public LinuxXbox360Controller(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        super(controller, leftStickDeadZone, rightStickDeadZone);
    }

    public void connected(Controller controller) {
    }

    public void disconnected(Controller controller) {
        this.notifyDisconnected();
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case -1: {
                return this.notifyButtonDown(Xbox360Button.UP);
            }
            case -2: {
                return this.notifyButtonDown(Xbox360Button.DOWN);
            }
            case -3: {
                return this.notifyButtonDown(Xbox360Button.LEFT);
            }
            case -4: {
                return this.notifyButtonDown(Xbox360Button.RIGHT);
            }
            case 7: {
                return this.notifyButtonDown(Xbox360Button.START);
            }
            case 6: {
                return this.notifyButtonDown(Xbox360Button.BACK);
            }
            case 9: {
                return this.notifyButtonDown(Xbox360Button.LEFT_STICK);
            }
            case 10: {
                return this.notifyButtonDown(Xbox360Button.RIGHT_STICK);
            }
            case 4: {
                return this.notifyButtonDown(Xbox360Button.LEFT_SHOULDER);
            }
            case 5: {
                return this.notifyButtonDown(Xbox360Button.RIGHT_SHOULDER);
            }
            case 8: {
                return this.notifyButtonDown(Xbox360Button.GUIDE);
            }
            case 0: {
                return this.notifyButtonDown(Xbox360Button.A);
            }
            case 1: {
                return this.notifyButtonDown(Xbox360Button.B);
            }
            case 2: {
                return this.notifyButtonDown(Xbox360Button.X);
            }
            case 3: {
                return this.notifyButtonDown(Xbox360Button.Y);
            }
        }
        return false;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case -1: {
                return this.notifyButtonUp(Xbox360Button.UP);
            }
            case -2: {
                return this.notifyButtonUp(Xbox360Button.DOWN);
            }
            case -3: {
                return this.notifyButtonUp(Xbox360Button.LEFT);
            }
            case -4: {
                return this.notifyButtonUp(Xbox360Button.RIGHT);
            }
            case 7: {
                return this.notifyButtonUp(Xbox360Button.START);
            }
            case 6: {
                return this.notifyButtonUp(Xbox360Button.BACK);
            }
            case 9: {
                return this.notifyButtonUp(Xbox360Button.LEFT_STICK);
            }
            case 10: {
                return this.notifyButtonUp(Xbox360Button.RIGHT_STICK);
            }
            case 4: {
                return this.notifyButtonUp(Xbox360Button.LEFT_SHOULDER);
            }
            case 5: {
                return this.notifyButtonUp(Xbox360Button.RIGHT_SHOULDER);
            }
            case 8: {
                return this.notifyButtonUp(Xbox360Button.GUIDE);
            }
            case 0: {
                return this.notifyButtonUp(Xbox360Button.A);
            }
            case 1: {
                return this.notifyButtonUp(Xbox360Button.B);
            }
            case 2: {
                return this.notifyButtonUp(Xbox360Button.X);
            }
            case 3: {
                return this.notifyButtonUp(Xbox360Button.Y);
            }
        }
        return false;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        switch (axisCode) {
            case 0: {
                return this.notifyLeftStickXMoved(value);
            }
            case 1: {
                return this.notifyLeftStickYMoved(value);
            }
            case 3: {
                return this.notifyRightStickXMoved(value);
            }
            case 4: {
                return this.notifyRightStickYMoved(value);
            }
            case 2: {
                return this.notifyLeftTriggerMoved(value);
            }
            case 5: {
                return this.notifyRightTriggerMoved(value);
            }
        }
        return false;
    }

    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        return false;
    }

    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean accelerometerMoved(Controller controller, int accelerometerCode, Vector3 value) {
        return false;
    }
}

