/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.xbox360;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import org.mini2Dx.core.controller.Xbox360Controller;
import org.mini2Dx.core.controller.button.Xbox360Button;
import org.mini2Dx.core.controller.deadzone.DeadZone;

public class WindowsXbox360Controller
extends Xbox360Controller {
    public static final int BUTTON_A = 0;
    public static final int BUTTON_B = 1;
    public static final int BUTTON_X = 2;
    public static final int BUTTON_Y = 3;
    public static final int BUTTON_LEFT_SHOULDER = 4;
    public static final int BUTTON_RIGHT_SHOULDER = 5;
    public static final int BUTTON_BACK = 6;
    public static final int BUTTON_START = 7;
    public static final int BUTTON_LEFT_STICK = 8;
    public static final int BUTTON_RIGHT_STICK = 9;
    public static final int BUTTON_GUIDE = -1;
    public static final int AXIS_LEFT_TRIGGER = 4;
    public static final int AXIS_RIGHT_TRIGGER = 4;
    public static final int AXIS_LEFT_STICK_Y = 0;
    public static final int AXIS_LEFT_STICK_X = 1;
    public static final int AXIS_RIGHT_STICK_Y = 2;
    public static final int AXIS_RIGHT_STICK_X = 3;
    public static final int POV_DIRECTIONS = 0;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;

    public WindowsXbox360Controller(Controller controller) {
        super(controller);
    }

    public WindowsXbox360Controller(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        super(controller, leftStickDeadZone, rightStickDeadZone);
    }

    public void connected(Controller controller) {
    }

    public void disconnected(Controller controller) {
        this.notifyDisconnected();
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case 7: {
                return this.notifyButtonDown(Xbox360Button.START);
            }
            case 6: {
                return this.notifyButtonDown(Xbox360Button.BACK);
            }
            case 8: {
                return this.notifyButtonDown(Xbox360Button.LEFT_STICK);
            }
            case 9: {
                return this.notifyButtonDown(Xbox360Button.RIGHT_STICK);
            }
            case 4: {
                return this.notifyButtonDown(Xbox360Button.LEFT_SHOULDER);
            }
            case 5: {
                return this.notifyButtonDown(Xbox360Button.RIGHT_SHOULDER);
            }
            case -1: {
                return this.notifyButtonDown(Xbox360Button.GUIDE);
            }
            case 0: {
                return this.notifyButtonDown(Xbox360Button.A);
            }
            case 1: {
                return this.notifyButtonDown(Xbox360Button.B);
            }
            case 2: {
                return this.notifyButtonDown(Xbox360Button.X);
            }
            case 3: {
                return this.notifyButtonDown(Xbox360Button.Y);
            }
        }
        return false;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case 7: {
                return this.notifyButtonUp(Xbox360Button.START);
            }
            case 6: {
                return this.notifyButtonUp(Xbox360Button.BACK);
            }
            case 8: {
                return this.notifyButtonUp(Xbox360Button.LEFT_STICK);
            }
            case 9: {
                return this.notifyButtonUp(Xbox360Button.RIGHT_STICK);
            }
            case 4: {
                return this.notifyButtonUp(Xbox360Button.LEFT_SHOULDER);
            }
            case 5: {
                return this.notifyButtonUp(Xbox360Button.RIGHT_SHOULDER);
            }
            case -1: {
                return this.notifyButtonUp(Xbox360Button.GUIDE);
            }
            case 0: {
                return this.notifyButtonUp(Xbox360Button.A);
            }
            case 1: {
                return this.notifyButtonUp(Xbox360Button.B);
            }
            case 2: {
                return this.notifyButtonUp(Xbox360Button.X);
            }
            case 3: {
                return this.notifyButtonUp(Xbox360Button.Y);
            }
        }
        return false;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        switch (axisCode) {
            case 1: {
                return this.notifyLeftStickXMoved(value);
            }
            case 0: {
                return this.notifyLeftStickYMoved(value);
            }
            case 3: {
                return this.notifyRightStickXMoved(value);
            }
            case 2: {
                return this.notifyRightStickYMoved(value);
            }
            case 4: {
                if (value > 0.0f) {
                    return this.notifyLeftTriggerMoved(value);
                }
                return this.notifyRightTriggerMoved(Math.abs(value));
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        switch (povCode) {
            case 0: {
                switch (value) {
                    case center: {
                        if (this.up) {
                            this.notifyButtonUp(Xbox360Button.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(Xbox360Button.DOWN);
                            this.down = false;
                        }
                        if (this.left) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.left = false;
                        }
                        if (!this.right) return false;
                        this.notifyButtonUp(Xbox360Button.RIGHT);
                        this.right = false;
                        break;
                    }
                    case east: {
                        if (this.up) {
                            this.notifyButtonUp(Xbox360Button.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(Xbox360Button.DOWN);
                            this.down = false;
                        }
                        if (this.left) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.left = false;
                        }
                        if (this.right) return false;
                        this.right = true;
                        this.notifyButtonDown(Xbox360Button.RIGHT);
                        break;
                    }
                    case north: {
                        if (this.left) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.left = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(Xbox360Button.RIGHT);
                            this.right = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(Xbox360Button.DOWN);
                            this.down = false;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(Xbox360Button.UP);
                        break;
                    }
                    case northEast: {
                        if (this.left) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.left = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(Xbox360Button.DOWN);
                            this.down = false;
                        }
                        if (!this.right) {
                            this.notifyButtonDown(Xbox360Button.RIGHT);
                            this.right = true;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(Xbox360Button.UP);
                        break;
                    }
                    case northWest: {
                        if (this.right) {
                            this.notifyButtonUp(Xbox360Button.RIGHT);
                            this.right = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(Xbox360Button.DOWN);
                            this.down = false;
                        }
                        if (!this.left) {
                            this.notifyButtonDown(Xbox360Button.LEFT);
                            this.left = true;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(Xbox360Button.UP);
                        break;
                    }
                    case south: {
                        if (this.left) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.left = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(Xbox360Button.RIGHT);
                            this.right = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(Xbox360Button.UP);
                            this.up = false;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(Xbox360Button.DOWN);
                        this.down = true;
                        break;
                    }
                    case southEast: {
                        if (this.left) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.left = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(Xbox360Button.UP);
                            this.up = false;
                        }
                        if (!this.right) {
                            this.notifyButtonDown(Xbox360Button.RIGHT);
                            this.right = true;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(Xbox360Button.DOWN);
                        this.down = true;
                        break;
                    }
                    case southWest: {
                        if (this.right) {
                            this.notifyButtonUp(Xbox360Button.RIGHT);
                            this.right = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(Xbox360Button.UP);
                            this.up = false;
                        }
                        if (!this.left) {
                            this.notifyButtonDown(Xbox360Button.LEFT);
                            this.left = true;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(Xbox360Button.DOWN);
                        this.down = true;
                        break;
                    }
                    case west: {
                        if (this.up) {
                            this.notifyButtonUp(Xbox360Button.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(Xbox360Button.DOWN);
                            this.down = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(Xbox360Button.LEFT);
                            this.right = false;
                        }
                        if (this.left) return false;
                        this.left = true;
                        this.notifyButtonDown(Xbox360Button.LEFT);
                        break;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean accelerometerMoved(Controller controller, int accelerometerCode, Vector3 value) {
        return false;
    }
}

