/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.controller.xboxone;

import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.PovDirection;
import com.badlogic.gdx.math.Vector3;
import org.mini2Dx.core.controller.XboxOneController;
import org.mini2Dx.core.controller.button.XboxOneButton;
import org.mini2Dx.core.controller.deadzone.DeadZone;

public class WindowsXboxOneController
extends XboxOneController {
    public static final int BUTTON_A = 0;
    public static final int BUTTON_B = 1;
    public static final int BUTTON_X = 2;
    public static final int BUTTON_Y = 3;
    public static final int BUTTON_LEFT_SHOULDER = 4;
    public static final int BUTTON_RIGHT_SHOULDER = 5;
    public static final int BUTTON_VIEW = 6;
    public static final int BUTTON_MENU = 7;
    public static final int BUTTON_LEFT_STICK = 8;
    public static final int BUTTON_RIGHT_STICK = 9;
    public static final int BUTTON_HOME = -1;
    public static final int AXIS_LEFT_STICK_Y = 0;
    public static final int AXIS_LEFT_STICK_X = 1;
    public static final int AXIS_RIGHT_STICK_Y = 2;
    public static final int AXIS_RIGHT_STICK_X = 3;
    public static final int AXIS_LEFT_TRIGGER = 4;
    public static final int AXIS_RIGHT_TRIGGER = 4;
    public static final int POV_DIRECTIONS = 0;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;

    public WindowsXboxOneController(Controller controller) {
        super(controller);
    }

    public WindowsXboxOneController(Controller controller, DeadZone leftStickDeadZone, DeadZone rightStickDeadZone) {
        super(controller, leftStickDeadZone, rightStickDeadZone);
    }

    public void connected(Controller controller) {
    }

    public void disconnected(Controller controller) {
        this.notifyDisconnected();
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case 7: {
                return this.notifyButtonDown(XboxOneButton.MENU);
            }
            case 6: {
                return this.notifyButtonDown(XboxOneButton.VIEW);
            }
            case 8: {
                return this.notifyButtonDown(XboxOneButton.LEFT_STICK);
            }
            case 9: {
                return this.notifyButtonDown(XboxOneButton.RIGHT_STICK);
            }
            case 4: {
                return this.notifyButtonDown(XboxOneButton.LEFT_SHOULDER);
            }
            case 5: {
                return this.notifyButtonDown(XboxOneButton.RIGHT_SHOULDER);
            }
            case -1: {
                return this.notifyButtonDown(XboxOneButton.HOME);
            }
            case 0: {
                return this.notifyButtonDown(XboxOneButton.A);
            }
            case 1: {
                return this.notifyButtonDown(XboxOneButton.B);
            }
            case 2: {
                return this.notifyButtonDown(XboxOneButton.X);
            }
            case 3: {
                return this.notifyButtonDown(XboxOneButton.Y);
            }
        }
        return false;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        switch (buttonCode) {
            case 7: {
                return this.notifyButtonUp(XboxOneButton.MENU);
            }
            case 6: {
                return this.notifyButtonUp(XboxOneButton.VIEW);
            }
            case 8: {
                return this.notifyButtonUp(XboxOneButton.LEFT_STICK);
            }
            case 9: {
                return this.notifyButtonUp(XboxOneButton.RIGHT_STICK);
            }
            case 4: {
                return this.notifyButtonUp(XboxOneButton.LEFT_SHOULDER);
            }
            case 5: {
                return this.notifyButtonUp(XboxOneButton.RIGHT_SHOULDER);
            }
            case -1: {
                return this.notifyButtonUp(XboxOneButton.HOME);
            }
            case 0: {
                return this.notifyButtonUp(XboxOneButton.A);
            }
            case 1: {
                return this.notifyButtonUp(XboxOneButton.B);
            }
            case 2: {
                return this.notifyButtonUp(XboxOneButton.X);
            }
            case 3: {
                return this.notifyButtonUp(XboxOneButton.Y);
            }
        }
        return false;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        switch (axisCode) {
            case 1: {
                return this.notifyLeftStickXMoved(value);
            }
            case 0: {
                return this.notifyLeftStickYMoved(value);
            }
            case 3: {
                return this.notifyRightStickXMoved(value);
            }
            case 2: {
                return this.notifyRightStickYMoved(value);
            }
            case 4: {
                if (value > 0.0f) {
                    return this.notifyLeftTriggerMoved(value);
                }
                return this.notifyRightTriggerMoved(Math.abs(value));
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean povMoved(Controller controller, int povCode, PovDirection value) {
        switch (povCode) {
            case 0: {
                switch (value) {
                    case center: {
                        if (this.up) {
                            this.notifyButtonUp(XboxOneButton.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(XboxOneButton.DOWN);
                            this.down = false;
                        }
                        if (this.left) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.left = false;
                        }
                        if (!this.right) return false;
                        this.notifyButtonUp(XboxOneButton.RIGHT);
                        this.right = false;
                        break;
                    }
                    case east: {
                        if (this.up) {
                            this.notifyButtonUp(XboxOneButton.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(XboxOneButton.DOWN);
                            this.down = false;
                        }
                        if (this.left) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.left = false;
                        }
                        if (this.right) return false;
                        this.right = true;
                        this.notifyButtonDown(XboxOneButton.RIGHT);
                        break;
                    }
                    case north: {
                        if (this.left) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.left = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(XboxOneButton.RIGHT);
                            this.right = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(XboxOneButton.DOWN);
                            this.down = false;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(XboxOneButton.UP);
                        break;
                    }
                    case northEast: {
                        if (this.left) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.left = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(XboxOneButton.DOWN);
                            this.down = false;
                        }
                        if (!this.right) {
                            this.notifyButtonDown(XboxOneButton.RIGHT);
                            this.right = true;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(XboxOneButton.UP);
                        break;
                    }
                    case northWest: {
                        if (this.right) {
                            this.notifyButtonUp(XboxOneButton.RIGHT);
                            this.right = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(XboxOneButton.DOWN);
                            this.down = false;
                        }
                        if (!this.left) {
                            this.notifyButtonDown(XboxOneButton.LEFT);
                            this.left = true;
                        }
                        if (this.up) return false;
                        this.up = true;
                        this.notifyButtonDown(XboxOneButton.UP);
                        break;
                    }
                    case south: {
                        if (this.left) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.left = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(XboxOneButton.RIGHT);
                            this.right = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(XboxOneButton.UP);
                            this.up = false;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(XboxOneButton.DOWN);
                        this.down = true;
                        break;
                    }
                    case southEast: {
                        if (this.left) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.left = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(XboxOneButton.UP);
                            this.up = false;
                        }
                        if (!this.right) {
                            this.notifyButtonDown(XboxOneButton.RIGHT);
                            this.right = true;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(XboxOneButton.DOWN);
                        this.down = true;
                        break;
                    }
                    case southWest: {
                        if (this.right) {
                            this.notifyButtonUp(XboxOneButton.RIGHT);
                            this.right = false;
                        }
                        if (this.up) {
                            this.notifyButtonUp(XboxOneButton.UP);
                            this.up = false;
                        }
                        if (!this.left) {
                            this.notifyButtonDown(XboxOneButton.LEFT);
                            this.left = true;
                        }
                        if (this.down) return false;
                        this.notifyButtonDown(XboxOneButton.DOWN);
                        this.down = true;
                        break;
                    }
                    case west: {
                        if (this.up) {
                            this.notifyButtonUp(XboxOneButton.UP);
                            this.up = false;
                        }
                        if (this.down) {
                            this.notifyButtonUp(XboxOneButton.DOWN);
                            this.down = false;
                        }
                        if (this.right) {
                            this.notifyButtonUp(XboxOneButton.LEFT);
                            this.right = false;
                        }
                        if (this.left) return false;
                        this.left = true;
                        this.notifyButtonDown(XboxOneButton.LEFT);
                        break;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean xSliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean ySliderMoved(Controller controller, int sliderCode, boolean value) {
        return false;
    }

    public boolean accelerometerMoved(Controller controller, int accelerometerCode, Vector3 value) {
        return false;
    }
}

