/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.di;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.mini2Dx.core.exception.MdxException;

public class BeanUtils {
    public Object cloneBean(Object bean) throws MdxException {
        try {
            Class<?> currentClass = bean.getClass();
            Object result = currentClass.newInstance();
            while (!currentClass.equals(Object.class)) {
                for (Field field : currentClass.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    Object value = field.get(bean);
                    field.set(result, value);
                }
                currentClass = currentClass.getSuperclass();
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new MdxException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new MdxException(e.getMessage(), e);
        }
    }
}

