/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.di;

import com.badlogic.gdx.utils.ObjectMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mini2Dx.core.di.BeanUtils;
import org.mini2Dx.core.di.ComponentScanner;
import org.mini2Dx.core.di.bean.Bean;
import org.mini2Dx.core.di.injection.BeanInjector;

public class DependencyInjection {
    private final ObjectMap<String, Object> presetSingletons = new ObjectMap();
    private final ObjectMap<String, Object> presetPrototypes = new ObjectMap();
    private final BeanUtils beanUtils;
    private final ComponentScanner componentScanner;
    private ObjectMap<String, Bean> beans;
    private ExecutorService prototypeService;

    public DependencyInjection(BeanUtils beanUtils, ComponentScanner componentScanner) {
        this.beanUtils = beanUtils;
        this.componentScanner = componentScanner;
    }

    public <T> void presetSingleton(T ref, Class<T> clazz) {
        this.presetSingletons.put((Object)Bean.getClassKey(clazz), ref);
    }

    public <T> void presetSingleton(Class<T> clazz) throws Exception {
        this.presetSingletons.put((Object)Bean.getClassKey(clazz), clazz.newInstance());
    }

    public <T> void presetPrototype(Class<T> clazz) throws Exception {
        this.presetPrototypes.put((Object)Bean.getClassKey(clazz), clazz.newInstance());
    }

    public void scan(String ... packageNames) throws Exception {
        String key;
        this.componentScanner.scan(packageNames);
        ObjectMap singletons = new ObjectMap(this.presetSingletons);
        ObjectMap prototypes = new ObjectMap(this.presetPrototypes);
        for (Class clazz : this.componentScanner.getSingletonClasses()) {
            key = Bean.getClassKey(clazz);
            singletons.put((Object)key, clazz.newInstance());
        }
        for (Class clazz : this.componentScanner.getPrototypeClasses()) {
            key = Bean.getClassKey(clazz);
            prototypes.put((Object)key, clazz.newInstance());
        }
        BeanInjector injector = new BeanInjector((ObjectMap<String, Object>)singletons, (ObjectMap<String, Object>)prototypes);
        injector.inject();
        this.prototypeService = Executors.newFixedThreadPool(1);
        this.beans = injector.getInjectionResult(this.prototypeService);
    }

    public void shutdown() {
        this.prototypeService.shutdown();
    }

    public <T> T getBean(Class<T> clazz) {
        String classKey = Bean.getClassKey(clazz);
        if (this.beans == null) {
            return null;
        }
        if (!this.beans.containsKey((Object)classKey)) {
            return null;
        }
        return (T)((Bean)this.beans.get((Object)classKey)).getInstance();
    }

    public BeanUtils beanUtils() {
        return this.beanUtils;
    }
}

