/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.di.bean;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.di.bean.Bean;
import org.mini2Dx.core.exception.MdxException;

public class PrototypeBean
extends Bean
implements Runnable {
    private static final int MAXIMUM_PREPARED_PROTOTYPES = 3;
    private Object bean;
    private BlockingQueue<Object> prototypes;
    private ExecutorService executorService;

    public PrototypeBean(Object bean, ExecutorService executorService) {
        this.bean = bean;
        this.executorService = executorService;
        this.prototypes = new ArrayBlockingQueue<Object>(3);
    }

    @Override
    public Object getInstance() {
        Object result = null;
        try {
            result = this.prototypes.take();
            this.executorService.submit(this);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Object duplicate(Object object) throws MdxException {
        return Mdx.di.beanUtils().cloneBean(object);
    }

    @Override
    public void run() {
        try {
            while (this.prototypes.size() < 3) {
                this.prototypes.offer(PrototypeBean.duplicate(this.bean));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

