/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.di.injection;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import org.mini2Dx.core.di.annotation.Autowired;
import org.mini2Dx.core.di.annotation.PostInject;
import org.mini2Dx.core.di.bean.Bean;
import org.mini2Dx.core.di.bean.PrototypeBean;
import org.mini2Dx.core.di.bean.SingletonBean;
import org.mini2Dx.core.di.exception.NoSuchBeanException;
import org.mini2Dx.core.di.exception.PostInjectException;
import org.mini2Dx.core.di.injection.PrototypeInjectionMap;

public class BeanInjector {
    private ObjectMap<String, Object> singletons;
    private ObjectMap<String, Object> prototypes;
    private ObjectMap<String, NoSuchBeanException> exceptions;

    public BeanInjector(ObjectMap<String, Object> singletons, ObjectMap<String, Object> prototypes) {
        this.singletons = singletons;
        this.prototypes = prototypes;
        this.exceptions = new ObjectMap();
    }

    public void inject() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        String key2;
        this.injectSingletons();
        this.injectPrototypes();
        this.checkInjectionSuccessful();
        for (String key2 : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key2);
            try {
                this.invokePostInject(object);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        ObjectMap.Keys keys = this.singletons.keys().iterator();
        while (keys.hasNext()) {
            key2 = (String)keys.next();
            object = this.singletons.get((Object)key2);
            try {
                this.invokePostInject(object);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.exceptions.size > 0 && (keys = this.exceptions.keys().iterator()).hasNext()) {
            key2 = (String)keys.next();
            throw (NoSuchBeanException)this.exceptions.get((Object)key2);
        }
    }

    public ObjectMap<String, Bean> getInjectionResult(ExecutorService prototypeExecutorService) {
        Object object;
        ObjectMap result = new ObjectMap();
        for (String key : this.singletons.keys()) {
            object = this.singletons.get((Object)key);
            result.put((Object)key, (Object)new SingletonBean(object));
        }
        for (String key : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key);
            PrototypeBean prototypeBean = new PrototypeBean(object, prototypeExecutorService);
            prototypeExecutorService.submit(prototypeBean);
            result.put((Object)key, (Object)prototypeBean);
        }
        return result;
    }

    private void invokePostInject(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : object.getClass().getMethods()) {
            if (!method.isAnnotationPresent(PostInject.class)) continue;
            if (method.getParameterTypes().length > 0) {
                throw new PostInjectException();
            }
            method.invoke(object, new Object[0]);
        }
    }

    private void injectPrototypes() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        PrototypeInjectionMap prototypeInjectionMap = new PrototypeInjectionMap(this.prototypes);
        for (String key : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key);
            this.inject(object, key, prototypeInjectionMap);
        }
        for (String key : this.singletons.keys()) {
            object = this.singletons.get((Object)key);
            this.inject(object, key, prototypeInjectionMap);
        }
    }

    private void injectSingletons() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        Array singletonKeys = new Array();
        Array prototypeKeys = new Array();
        for (String key : this.singletons.keys()) {
            singletonKeys.add((Object)key);
        }
        for (String key : this.prototypes.keys()) {
            prototypeKeys.add((Object)key);
        }
        for (String key : singletonKeys) {
            object = this.singletons.get((Object)key);
            this.inject(object, key, this.singletons);
        }
        for (String key : prototypeKeys) {
            object = this.prototypes.get((Object)key);
            this.inject(object, key, this.singletons);
        }
    }

    private void checkInjectionSuccessful() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        for (String key : this.singletons.keys()) {
            object = this.singletons.get((Object)key);
            this.checkInjectionSuccessful(object, key);
        }
        for (String key : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key);
            this.checkInjectionSuccessful(object, key);
        }
    }

    private void checkInjectionSuccessful(Object object, String objectKey) throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Class<?> currentClass = object.getClass();
        while (!currentClass.equals(Object.class)) {
            for (Field field : currentClass.getDeclaredFields()) {
                field.setAccessible(true);
                Autowired autowireAnnotaiton = field.getAnnotation(Autowired.class);
                Object value = field.get(object);
                if (autowireAnnotaiton == null || value != null || !autowireAnnotaiton.required()) continue;
                Class<?> clazz = field.getType();
                String clazzKey = Bean.getClassKey(clazz);
                this.exceptions.put((Object)clazzKey, (Object)new NoSuchBeanException(object.getClass().getSimpleName(), field.getName(), clazz.getSimpleName()));
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    private void inject(Object object, String objectKey, ObjectMap<String, Object> beans) throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Class<?> currentClass = object.getClass();
        while (!currentClass.equals(Object.class)) {
            block1: for (Field field : currentClass.getDeclaredFields()) {
                field.setAccessible(true);
                Autowired autowireAnnotaiton = field.getAnnotation(Autowired.class);
                Object value = field.get(object);
                if (autowireAnnotaiton == null || value != null) continue;
                Class<?> clazz = field.getType();
                String clazzKey = Bean.getClassKey(clazz);
                if (beans.containsKey((Object)clazzKey)) {
                    Object dependency = beans.get((Object)clazzKey);
                    field.set(object, dependency);
                    continue;
                }
                if (!clazz.isInterface()) continue;
                boolean found = false;
                for (String beanKey : beans.keys()) {
                    if (beanKey.compareTo(objectKey) == 0) continue;
                    Object beanToInject = beans.get((Object)beanKey);
                    for (Class<?> interfaceImpl : beanToInject.getClass().getInterfaces()) {
                        if (!interfaceImpl.equals(clazz)) continue;
                        field.set(object, beanToInject);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
            currentClass = currentClass.getSuperclass();
        }
    }
}

