/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.engine.geom;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mini2Dx.core.engine.PositionChangeListener;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.engine.SizeChangeListener;
import org.mini2Dx.core.engine.Sizeable;
import org.mini2Dx.core.engine.geom.CollisionIdSequence;
import org.mini2Dx.core.engine.geom.CollisionShape;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;

public class CollisionBox
extends Rectangle
implements CollisionShape {
    private static final long serialVersionUID = -8217730724587578266L;
    private static final Vector2 TMP_SOURCE_VECTOR = new Vector2();
    private static final Vector2 TMP_TARGET_VECTOR = new Vector2();
    private final int id;
    private final ReentrantReadWriteLock positionChangeListenerLock;
    private final ReentrantReadWriteLock sizeChangeListenerLock;
    private final Rectangle previousRectangle;
    private final Rectangle renderRectangle;
    private Array<PositionChangeListener> positionChangeListeners;
    private Array<SizeChangeListener> sizeChangeListeners;
    private int renderX;
    private int renderY;
    private int renderWidth;
    private int renderHeight;
    private boolean interpolate = false;

    public CollisionBox() {
        this(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public CollisionBox(int id) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public CollisionBox(float x, float y, float width, float height) {
        this(CollisionIdSequence.nextId(), x, y, width, height);
    }

    public CollisionBox(int id, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.id = id;
        this.positionChangeListenerLock = new ReentrantReadWriteLock();
        this.sizeChangeListenerLock = new ReentrantReadWriteLock();
        this.previousRectangle = new Rectangle(x, y, width, height);
        this.renderRectangle = new Rectangle(x, y, width, height);
        this.storeRenderCoordinates();
    }

    private void storeRenderCoordinates() {
        this.renderX = MathUtils.round((float)this.renderRectangle.getX());
        this.renderY = MathUtils.round((float)this.renderRectangle.getY());
        this.renderWidth = MathUtils.round((float)this.renderRectangle.getWidth());
        this.renderHeight = MathUtils.round((float)this.renderRectangle.getHeight());
    }

    @Override
    public void preUpdate() {
        this.previousRectangle.set(this);
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
        if (!this.interpolate) {
            return;
        }
        this.renderRectangle.set(this.previousRectangle.lerp(this, alpha));
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.getX())) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.getY())) {
            return;
        }
        if (this.renderWidth != MathUtils.round((float)this.getWidth())) {
            return;
        }
        if (this.renderHeight != MathUtils.round((float)this.getHeight())) {
            return;
        }
        this.interpolate = false;
    }

    @Override
    public void draw(Graphics g) {
        this.renderRectangle.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.renderRectangle.fill(g);
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.writeLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 1);
        }
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.readLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListenerLock.readLock().unlock();
            return;
        }
        this.positionChangeListenerLock.readLock().unlock();
        this.positionChangeListenerLock.writeLock().lock();
        this.positionChangeListeners.removeValue(listener, false);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    private void notifyPositionChangeListeners() {
        this.positionChangeListenerLock.readLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListenerLock.readLock().unlock();
            return;
        }
        for (int i = this.positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.positionChangeListeners.size) {
                i = this.positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)this.positionChangeListeners.get(i);
            this.positionChangeListenerLock.readLock().unlock();
            listener.positionChanged(this);
            this.positionChangeListenerLock.readLock().lock();
        }
        this.positionChangeListenerLock.readLock().unlock();
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.writeLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListeners = new Array(true, 1);
        }
        this.sizeChangeListeners.add(listener);
        this.sizeChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.readLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListenerLock.readLock().unlock();
            return;
        }
        this.sizeChangeListenerLock.readLock().unlock();
        this.sizeChangeListenerLock.writeLock().lock();
        this.sizeChangeListeners.removeValue(listener, false);
        this.sizeChangeListenerLock.writeLock().unlock();
    }

    private void notifySizeChangeListeners() {
        this.sizeChangeListenerLock.readLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListenerLock.readLock().unlock();
            return;
        }
        for (int i = this.sizeChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.sizeChangeListeners.size) {
                i = this.sizeChangeListeners.size - 1;
            }
            SizeChangeListener listener = (SizeChangeListener)this.sizeChangeListeners.get(i);
            this.sizeChangeListenerLock.readLock().unlock();
            listener.sizeChanged(this);
            this.sizeChangeListenerLock.readLock().lock();
        }
        this.sizeChangeListenerLock.readLock().unlock();
    }

    @Override
    public void setRotation(float degrees) {
        if (degrees == this.getRotation()) {
            return;
        }
        super.setRotation(degrees);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        super.rotate(degrees);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        super.rotateAround(centerX, centerY, degrees);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setRotationAround(Point center, float degrees) {
        if (center.x == this.getX() && center.y == this.getY() && degrees == this.getRotation()) {
            return;
        }
        super.setRotationAround(center, degrees);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        if (centerX == this.getX() && centerY == this.getY() && degrees == this.getRotation()) {
            return;
        }
        super.setRotationAround(centerX, centerY, degrees);
        this.notifyPositionChangeListeners();
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.getDistanceTo(positionable.getX(), positionable.getY());
    }

    @Override
    public void forceTo(float x, float y) {
        this.forceTo(x, y, this.getWidth(), this.getHeight());
    }

    public void forceTo(float x, float y, float width, float height) {
        boolean notifyPositionListeners = x != this.getX() || y != this.getY();
        boolean notifySizeListeners = width != this.getWidth() || height != this.getHeight();
        super.set(x, y, width, height);
        this.previousRectangle.set(x, y, width, height);
        this.renderRectangle.set(this.previousRectangle);
        this.storeRenderCoordinates();
        this.interpolate = false;
        if (notifyPositionListeners) {
            this.notifyPositionChangeListeners();
        }
        if (notifySizeListeners) {
            this.notifySizeChangeListeners();
        }
    }

    public void forceTo(Rectangle rectangle) {
        this.forceTo(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void forceToWidth(float width) {
        super.setWidth(width);
        this.previousRectangle.set(this);
        this.renderRectangle.set(this);
        this.storeRenderCoordinates();
        this.notifySizeChangeListeners();
    }

    public void forceToHeight(float height) {
        super.setHeight(height);
        this.previousRectangle.set(this);
        this.renderRectangle.set(this);
        this.storeRenderCoordinates();
        this.notifySizeChangeListeners();
    }

    @Override
    public void moveTowards(float x, float y, float speed) {
        TMP_SOURCE_VECTOR.set(this.getX(), this.getY());
        TMP_TARGET_VECTOR.set(x, y);
        Vector2 direction = TMP_TARGET_VECTOR.sub(TMP_SOURCE_VECTOR).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angle());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angle());
        TMP_SOURCE_VECTOR.add(xComponent, yComponent);
        this.set(CollisionBox.TMP_SOURCE_VECTOR.x, CollisionBox.TMP_SOURCE_VECTOR.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    @Override
    public void add(float x, float y) {
        super.add(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void subtract(float x, float y) {
        super.subtract(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public Rectangle set(float x, float y, float width, float height) {
        boolean notifySizeListeners;
        boolean notifyPositionListeners = x != this.getX() || y != this.getY();
        boolean bl = notifySizeListeners = width != this.getWidth() || height != this.getHeight();
        if (notifyPositionListeners || notifySizeListeners) {
            super.set(x, y, width, height);
            this.interpolate = true;
        }
        if (notifyPositionListeners) {
            this.notifyPositionChangeListeners();
        }
        if (notifySizeListeners) {
            this.notifySizeChangeListeners();
        }
        return this;
    }

    @Override
    public void set(Rectangle rectangle) {
        boolean notifySizeListeners;
        boolean notifyPositionListeners = rectangle.getX() != this.getX() || rectangle.getY() != this.getY();
        boolean bl = notifySizeListeners = rectangle.getWidth() != this.getWidth() || rectangle.getHeight() != this.getHeight();
        if (notifyPositionListeners || notifySizeListeners) {
            super.set(rectangle);
            this.interpolate = true;
        }
        if (notifyPositionListeners) {
            this.notifyPositionChangeListeners();
        }
        if (notifySizeListeners) {
            this.notifySizeChangeListeners();
        }
    }

    @Override
    public void set(float x, float y) {
        if (x == this.getX() && y == this.getY()) {
            return;
        }
        super.set(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void set(Vector2 position) {
        if (this.getX() == position.x && this.getY() == position.y) {
            return;
        }
        super.set(position);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setX(float x) {
        if (x == this.getX()) {
            return;
        }
        super.setX(x);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setY(float y) {
        if (y == this.getY()) {
            return;
        }
        super.setY(y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public Rectangle setWidth(float width) {
        if (width == this.getWidth()) {
            return this;
        }
        super.setWidth(width);
        this.interpolate = true;
        this.notifySizeChangeListeners();
        return this;
    }

    @Override
    public void setCenter(float x, float y) {
        if (x == this.getCenterX() && y == this.getCenterY()) {
            return;
        }
        super.setCenter(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterX(float x) {
        if (x == this.getCenterX()) {
            return;
        }
        super.setCenterX(x);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterY(float y) {
        if (y == this.getCenterY()) {
            return;
        }
        super.setCenterY(y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public Rectangle setHeight(float height) {
        if (height == this.getHeight()) {
            return this;
        }
        super.setHeight(height);
        this.interpolate = true;
        this.notifySizeChangeListeners();
        return this;
    }

    @Override
    public Rectangle setSize(float width, float height) {
        if (width == this.getWidth() && height == this.getHeight()) {
            return this;
        }
        super.setSize(width, height);
        this.interpolate = true;
        this.notifySizeChangeListeners();
        return this;
    }

    @Override
    public Rectangle setSize(float sizeXY) {
        if (this.getWidth() == sizeXY && this.getHeight() == sizeXY) {
            return this;
        }
        super.setSize(sizeXY);
        this.interpolate = true;
        this.notifySizeChangeListeners();
        return this;
    }

    @Override
    public void setRadius(float radius) {
        super.setRadius(radius);
        this.interpolate = true;
        this.notifySizeChangeListeners();
    }

    @Override
    public void scale(float scale) {
        super.scale(scale);
        this.interpolate = true;
        this.notifySizeChangeListeners();
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    public int getRenderWidth() {
        return this.renderWidth;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public float getRenderRotation() {
        return this.renderRectangle.getRotation();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Shape getShape() {
        return this;
    }

    @Override
    public String toString() {
        return "CollisionBox [id=" + this.id + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", getRotation()=" + this.getRotation() + ", renderRectangle=" + this.renderRectangle + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollisionBox that = (CollisionBox)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

