/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.engine.geom;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mini2Dx.core.engine.PositionChangeListener;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.engine.SizeChangeListener;
import org.mini2Dx.core.engine.Sizeable;
import org.mini2Dx.core.engine.geom.CollisionIdSequence;
import org.mini2Dx.core.engine.geom.CollisionShape;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;

public class CollisionCircle
extends Circle
implements CollisionShape {
    private static final Vector2 TMP_SOURCE_VECTOR = new Vector2();
    private static final Vector2 TMP_TARGET_VECTOR = new Vector2();
    private final int id;
    private final ReadWriteLock positionChangeListenerLock;
    private final ReadWriteLock sizeChangeListenerLock;
    private Array<PositionChangeListener> positionChangeListeners;
    private Array<SizeChangeListener> sizeChangeListeners;
    private Circle previousCircle;
    private Circle renderCircle;
    private int renderX;
    private int renderY;
    private boolean interpolate = false;

    public CollisionCircle(float radius) {
        this(CollisionIdSequence.nextId(), radius);
    }

    public CollisionCircle(int id, float radius) {
        this(id, 0.0f, 0.0f, radius);
    }

    public CollisionCircle(float centerX, float centerY, float radius) {
        this(CollisionIdSequence.nextId(), centerX, centerY, radius);
    }

    public CollisionCircle(int id, float centerX, float centerY, float radius) {
        super(centerX, centerY, radius);
        this.id = id;
        this.positionChangeListenerLock = new ReentrantReadWriteLock();
        this.sizeChangeListenerLock = new ReentrantReadWriteLock();
        this.previousCircle = new Circle(centerX, centerY, radius);
        this.renderCircle = new Circle(centerX, centerY, radius);
        this.storeRenderCoordinates();
    }

    private void storeRenderCoordinates() {
        this.renderX = MathUtils.round((float)this.renderCircle.getX());
        this.renderY = MathUtils.round((float)this.renderCircle.getY());
    }

    @Override
    public void preUpdate() {
        this.previousCircle.set(this);
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
        if (!this.interpolate) {
            return;
        }
        this.renderCircle.set(this.previousCircle.lerp(this, alpha));
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.getX())) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.getY())) {
            return;
        }
        this.interpolate = false;
    }

    @Override
    public void draw(Graphics g) {
        this.renderCircle.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.renderCircle.fill(g);
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.getDistanceTo(positionable.getX(), positionable.getY());
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.writeLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 2);
        }
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.readLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListenerLock.readLock().unlock();
            return;
        }
        this.positionChangeListenerLock.readLock().unlock();
        this.positionChangeListenerLock.writeLock().lock();
        this.positionChangeListeners.removeValue(listener, false);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    private void notifyPositionChangeListeners() {
        this.positionChangeListenerLock.readLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListenerLock.readLock().unlock();
            return;
        }
        for (int i = this.positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.positionChangeListeners.size) {
                i = this.positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)this.positionChangeListeners.get(i);
            this.positionChangeListenerLock.readLock().unlock();
            listener.positionChanged(this);
            this.positionChangeListenerLock.readLock().lock();
        }
        this.positionChangeListenerLock.readLock().unlock();
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.writeLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListeners = new Array(true, 2);
        }
        this.sizeChangeListeners.add(listener);
        this.sizeChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.readLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListenerLock.readLock().unlock();
            return;
        }
        this.sizeChangeListenerLock.readLock().unlock();
        this.sizeChangeListenerLock.writeLock().lock();
        this.sizeChangeListeners.removeValue(listener, false);
        this.sizeChangeListenerLock.writeLock().unlock();
    }

    private void notifySizeChangeListeners() {
        this.sizeChangeListenerLock.readLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListenerLock.readLock().unlock();
            return;
        }
        for (int i = this.sizeChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.sizeChangeListeners.size) {
                i = this.sizeChangeListeners.size - 1;
            }
            SizeChangeListener listener = (SizeChangeListener)this.sizeChangeListeners.get(i);
            this.sizeChangeListenerLock.readLock().unlock();
            listener.sizeChanged(this);
            this.sizeChangeListenerLock.readLock().lock();
        }
        this.sizeChangeListenerLock.readLock().unlock();
    }

    @Override
    public void forceTo(float x, float y) {
        boolean notifyPositionListeners = x != this.getX() || y != this.getY();
        super.set(x, y);
        this.previousCircle.set(x, y);
        this.renderCircle.set(x, y);
        this.storeRenderCoordinates();
        if (!notifyPositionListeners) {
            return;
        }
        this.notifyPositionChangeListeners();
    }

    @Override
    public void moveTowards(float x, float y, float speed) {
        TMP_SOURCE_VECTOR.set(this.getX(), this.getY());
        TMP_TARGET_VECTOR.set(x, y);
        Vector2 direction = TMP_TARGET_VECTOR.sub(TMP_SOURCE_VECTOR).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angle());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angle());
        TMP_SOURCE_VECTOR.add(xComponent, yComponent);
        this.set(CollisionCircle.TMP_SOURCE_VECTOR.x, CollisionCircle.TMP_SOURCE_VECTOR.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    @Override
    public void add(float x, float y) {
        super.add(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void subtract(float x, float y) {
        super.subtract(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setX(float x) {
        if (x == this.getX()) {
            return;
        }
        super.setX(x);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setY(float y) {
        if (y == this.getY()) {
            return;
        }
        super.setY(y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void set(float x, float y) {
        if (x == this.getX() && y == this.getY()) {
            return;
        }
        super.set(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setRadius(float radius) {
        if (radius == this.getRadius()) {
            return;
        }
        super.setRadius(radius);
        this.interpolate = true;
        this.notifySizeChangeListeners();
    }

    @Override
    public void setCenter(float x, float y) {
        if (x == this.getCenterX() && y == this.getCenterY()) {
            return;
        }
        super.setCenter(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterX(float x) {
        if (x == this.getCenterX()) {
            return;
        }
        super.setCenterX(x);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterY(float y) {
        if (y == this.getCenterY()) {
            return;
        }
        super.setCenterY(y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void scale(float scale) {
        super.scale(scale);
        this.interpolate = true;
        this.notifySizeChangeListeners();
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    public float getRenderRadius() {
        return this.renderCircle.getRadius();
    }

    public float getPreviousX() {
        return this.previousCircle.getX();
    }

    public float getPreviousY() {
        return this.previousCircle.getY();
    }

    public float getPreviousRadius() {
        return this.previousCircle.getRadius();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public float getWidth() {
        return this.getRadius() * 2.0f;
    }

    @Override
    public float getHeight() {
        return this.getRadius() * 2.0f;
    }

    @Override
    public Shape getShape() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollisionCircle that = (CollisionCircle)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

