/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.engine.geom;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mini2Dx.core.engine.PositionChangeListener;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.engine.geom.CollisionIdSequence;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.geom.Point;

public class CollisionPoint
extends Point
implements Positionable {
    private static final long serialVersionUID = -7752697723641315393L;
    private static final Vector2 TMP_SOURCE_VECTOR = new Vector2();
    private static final Vector2 TMP_TARGET_VECTOR = new Vector2();
    private final int id;
    private final ReadWriteLock positionChangeListenerLock;
    private Array<PositionChangeListener> positionChangeListeners;
    private Point previousPosition;
    private Point renderPosition;
    private int renderX;
    private int renderY;
    private boolean interpolate = false;

    public CollisionPoint() {
        this(0.0f, 0.0f);
    }

    public CollisionPoint(int id) {
        this(id, 0.0f, 0.0f);
    }

    public CollisionPoint(float x, float y) {
        this(CollisionIdSequence.nextId(), x, y);
    }

    public CollisionPoint(int id, float x, float y) {
        super(x, y);
        this.id = id;
        this.positionChangeListenerLock = new ReentrantReadWriteLock();
        this.previousPosition = new Point(x, y);
        this.renderPosition = new Point(x, y);
        this.storeRenderCoordinates();
    }

    public CollisionPoint(Point point) {
        this(CollisionIdSequence.nextId(), point);
    }

    public CollisionPoint(int id, Point point) {
        super(point);
        this.id = id;
        this.positionChangeListenerLock = new ReentrantReadWriteLock();
        this.previousPosition = new Point(point);
        this.renderPosition = new Point(point);
        this.storeRenderCoordinates();
    }

    private void storeRenderCoordinates() {
        this.renderX = MathUtils.round((float)this.renderPosition.getX());
        this.renderY = MathUtils.round((float)this.renderPosition.getY());
    }

    public void preUpdate() {
        this.previousPosition.set(this);
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
        if (!this.interpolate) {
            return;
        }
        this.renderPosition.set(this.previousPosition.lerp(this, alpha));
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.x)) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.y)) {
            return;
        }
        this.interpolate = false;
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.dst(positionable.getX(), positionable.getY());
    }

    private void notifyPositionChangeListeners() {
        if (this.positionChangeListeners == null) {
            return;
        }
        this.positionChangeListenerLock.readLock().lock();
        for (int i = this.positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.positionChangeListeners.size) {
                i = this.positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)this.positionChangeListeners.get(i);
            this.positionChangeListenerLock.readLock().unlock();
            listener.positionChanged(this);
            this.positionChangeListenerLock.readLock().lock();
        }
        this.positionChangeListenerLock.readLock().unlock();
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.writeLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 1);
        }
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        if (this.positionChangeListeners == null) {
            return;
        }
        this.positionChangeListenerLock.writeLock().lock();
        this.positionChangeListeners.removeValue(listener, false);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    @Override
    public void moveTowards(float x, float y, float speed) {
        TMP_SOURCE_VECTOR.set(this.getX(), this.getY());
        TMP_TARGET_VECTOR.set(x, y);
        Vector2 direction = TMP_TARGET_VECTOR.sub(TMP_SOURCE_VECTOR).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angle());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angle());
        TMP_SOURCE_VECTOR.add(xComponent, yComponent);
        this.set(CollisionPoint.TMP_SOURCE_VECTOR.x, CollisionPoint.TMP_SOURCE_VECTOR.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    public void forceTo(float x, float y) {
        boolean notifyPositionListeners = x != this.getX() || y != this.getY();
        super.set(x, y);
        this.previousPosition.set(x, y);
        this.renderPosition.set(x, y);
        this.storeRenderCoordinates();
        if (!notifyPositionListeners) {
            return;
        }
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setX(float x) {
        if (x == this.getX()) {
            return;
        }
        super.set(x, this.getY());
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setY(float y) {
        if (y == this.getY()) {
            return;
        }
        super.set(this.getX(), y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    public Vector2 set(float x, float y) {
        if (x == this.getX() && y == this.getY()) {
            return this;
        }
        super.set(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 add(float x, float y) {
        if (x == 0.0f && y == 0.0f) {
            return this;
        }
        super.add(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 sub(float x, float y) {
        if (x == 0.0f && y == 0.0f) {
            return this;
        }
        super.sub(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
        return this;
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollisionPoint that = (CollisionPoint)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

