/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.engine.geom;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mini2Dx.core.engine.PositionChangeListener;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.engine.SizeChangeListener;
import org.mini2Dx.core.engine.Sizeable;
import org.mini2Dx.core.engine.geom.CollisionIdSequence;
import org.mini2Dx.core.engine.geom.CollisionShape;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;

public class CollisionPolygon
extends Polygon
implements CollisionShape {
    private static final Vector2 TMP_SOURCE_VECTOR = new Vector2();
    private static final Vector2 TMP_TARGET_VECTOR = new Vector2();
    private final int id;
    private final ReentrantReadWriteLock positionChangeListenerLock;
    private final ReentrantReadWriteLock sizeChangeListenerLock;
    private Array<PositionChangeListener> positionChangeListeners;
    private Array<SizeChangeListener> sizeChangeListeners;
    private Polygon previousPolygon;
    private Polygon renderPolygon;
    private int renderX;
    private int renderY;
    private boolean interpolate = false;

    public CollisionPolygon(float[] vertices) {
        this(CollisionIdSequence.nextId(), vertices);
    }

    public CollisionPolygon(Vector2[] vectors) {
        this(CollisionIdSequence.nextId(), vectors);
    }

    public CollisionPolygon(int id, float[] vertices) {
        super(vertices);
        this.id = id;
        this.positionChangeListenerLock = new ReentrantReadWriteLock();
        this.sizeChangeListenerLock = new ReentrantReadWriteLock();
    }

    public CollisionPolygon(int id, Vector2[] vectors) {
        super(vectors);
        this.id = id;
        this.positionChangeListenerLock = new ReentrantReadWriteLock();
        this.sizeChangeListenerLock = new ReentrantReadWriteLock();
    }

    private void storeRenderCoordinates() {
        this.renderX = MathUtils.round((float)this.renderPolygon.getX());
        this.renderY = MathUtils.round((float)this.renderPolygon.getY());
    }

    @Override
    public void preUpdate() {
        this.previousPolygon.set(this);
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
        if (!this.interpolate) {
            return;
        }
        this.renderPolygon.set(this.previousPolygon.lerp(this, alpha));
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.getX())) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.getY())) {
            return;
        }
        this.interpolate = false;
    }

    @Override
    public void draw(Graphics g) {
        this.renderPolygon.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.renderPolygon.fill(g);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.getDistanceTo(positionable.getX(), positionable.getY());
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.writeLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 1);
        }
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.readLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListenerLock.readLock().unlock();
            return;
        }
        this.positionChangeListenerLock.readLock().unlock();
        this.positionChangeListenerLock.writeLock().lock();
        this.positionChangeListeners.removeValue(listener, false);
        this.positionChangeListenerLock.writeLock().unlock();
    }

    private void notifyPositionChangeListeners() {
        this.positionChangeListenerLock.readLock().lock();
        if (this.positionChangeListeners == null) {
            this.positionChangeListenerLock.readLock().unlock();
            return;
        }
        for (int i = this.positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.positionChangeListeners.size) {
                i = this.positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)this.positionChangeListeners.get(i);
            this.positionChangeListenerLock.readLock().unlock();
            listener.positionChanged(this);
            this.positionChangeListenerLock.readLock().lock();
        }
        this.positionChangeListenerLock.readLock().unlock();
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.writeLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListeners = new Array(true, 1);
        }
        this.sizeChangeListeners.add(listener);
        this.sizeChangeListenerLock.writeLock().unlock();
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.readLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListenerLock.readLock().unlock();
            return;
        }
        this.sizeChangeListenerLock.readLock().unlock();
        this.sizeChangeListenerLock.writeLock().lock();
        this.sizeChangeListeners.removeValue(listener, false);
        this.sizeChangeListenerLock.writeLock().unlock();
    }

    private void notifySizeChangeListeners() {
        this.sizeChangeListenerLock.readLock().lock();
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListenerLock.readLock().unlock();
            return;
        }
        for (int i = this.sizeChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.sizeChangeListeners.size) {
                i = this.sizeChangeListeners.size - 1;
            }
            SizeChangeListener listener = (SizeChangeListener)this.sizeChangeListeners.get(i);
            this.sizeChangeListenerLock.readLock().unlock();
            listener.sizeChanged(this);
            this.sizeChangeListenerLock.readLock().lock();
        }
        this.sizeChangeListenerLock.readLock().unlock();
    }

    @Override
    public void addPoint(float x, float y) {
        super.addPoint(x, y);
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void removePoint(float x, float y) {
        super.removePoint(x, y);
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void moveTowards(float x, float y, float speed) {
        TMP_SOURCE_VECTOR.set(this.getX(), this.getY());
        TMP_TARGET_VECTOR.set(x, y);
        Vector2 direction = TMP_TARGET_VECTOR.sub(TMP_SOURCE_VECTOR).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angle());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angle());
        TMP_SOURCE_VECTOR.add(xComponent, yComponent);
        this.set(CollisionPolygon.TMP_SOURCE_VECTOR.x, CollisionPolygon.TMP_SOURCE_VECTOR.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    @Override
    public void add(float x, float y) {
        super.add(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void subtract(float x, float y) {
        super.subtract(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setX(float x) {
        if (x == this.getX()) {
            return;
        }
        super.setX(x);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void setY(float y) {
        if (y == this.getY()) {
            return;
        }
        super.setY(y);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void set(float x, float y) {
        if (x == this.getX() && y == this.getY()) {
            return;
        }
        super.set(x, y);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void setCenter(float x, float y) {
        if (x == this.getCenterX() && y == this.getCenterY()) {
            return;
        }
        super.setCenter(x, y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterX(float x) {
        if (x == this.getCenterX()) {
            return;
        }
        super.setCenterX(x);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterY(float y) {
        if (y == this.getCenterY()) {
            return;
        }
        super.setCenterY(y);
        this.interpolate = true;
        this.notifyPositionChangeListeners();
    }

    @Override
    public void forceTo(float x, float y) {
        boolean notifyPositionListeners = x != this.getX() || y != this.getY();
        super.set(x, y);
        this.previousPolygon.set(this);
        this.renderPolygon.set(this.previousPolygon);
        if (notifyPositionListeners) {
            this.notifyPositionChangeListeners();
        }
    }

    @Override
    public void setRotation(float degrees) {
        if (this.getRotation() == degrees) {
            return;
        }
        super.setRotation(degrees);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void rotate(float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        super.rotate(degrees);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        if (this.getRotation() == degrees && centerX == this.getX() && centerY == this.getY()) {
            return;
        }
        super.setRotationAround(centerX, centerY, degrees);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        super.rotateAround(centerX, centerY, degrees);
        this.notifyPositionChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void setVertices(float[] vertices) {
        super.setVertices(vertices);
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void setVertices(Vector2[] vertices) {
        super.setVertices(vertices);
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
        this.interpolate = true;
    }

    @Override
    public void setRadius(float radius) {
        super.setRadius(radius);
        this.interpolate = true;
        this.notifySizeChangeListeners();
    }

    @Override
    public void scale(float scale) {
        super.scale(scale);
        this.interpolate = true;
        this.notifySizeChangeListeners();
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    @Override
    public float getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    @Override
    public float getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    @Override
    public Shape getShape() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CollisionPolygon that = (CollisionPolygon)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

