/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.engine.geom;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.Objects;
import org.mini2Dx.core.engine.PositionChangeListener;
import org.mini2Dx.core.engine.Positionable;
import org.mini2Dx.core.engine.SizeChangeListener;
import org.mini2Dx.core.engine.Sizeable;
import org.mini2Dx.core.engine.geom.CollisionIdSequence;
import org.mini2Dx.core.engine.geom.CollisionShape;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.Shape;

public class StaticCollisionCircle
extends Circle
implements CollisionShape {
    private static final Vector2 TMP_SOURCE_VECTOR = new Vector2();
    private static final Vector2 TMP_TARGET_VECTOR = new Vector2();
    private final int id;
    private Array<PositionChangeListener> positionChangeListeners;
    private Array<SizeChangeListener> sizeChangeListeners;

    public StaticCollisionCircle(float radius) {
        this(CollisionIdSequence.nextId(), radius);
    }

    public StaticCollisionCircle(int id, float radius) {
        this(id, 0.0f, 0.0f, radius);
    }

    public StaticCollisionCircle(float centerX, float centerY, float radius) {
        this(CollisionIdSequence.nextId(), centerX, centerY, radius);
    }

    public StaticCollisionCircle(int id, float centerX, float centerY, float radius) {
        super(centerX, centerY, radius);
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRenderX() {
        return MathUtils.round((float)this.getX());
    }

    @Override
    public int getRenderY() {
        return MathUtils.round((float)this.getY());
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.getDistanceTo(positionable.getX(), positionable.getY());
    }

    @Override
    public void moveTowards(float x, float y, float speed) {
        TMP_SOURCE_VECTOR.set(this.getX(), this.getY());
        TMP_TARGET_VECTOR.set(x, y);
        Vector2 direction = TMP_TARGET_VECTOR.sub(TMP_SOURCE_VECTOR).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angle());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angle());
        TMP_SOURCE_VECTOR.add(xComponent, yComponent);
        this.set(StaticCollisionCircle.TMP_SOURCE_VECTOR.x, StaticCollisionCircle.TMP_SOURCE_VECTOR.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    @Override
    public void preUpdate() {
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 1);
        }
        this.positionChangeListeners.add(listener);
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        if (this.positionChangeListeners == null) {
            return;
        }
        this.positionChangeListeners.removeValue(listener, false);
    }

    private void notifyPositionChangeListeners() {
        if (this.positionChangeListeners == null) {
            return;
        }
        for (int i = this.positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.positionChangeListeners.size) {
                i = this.positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)this.positionChangeListeners.get(i);
            listener.positionChanged(this);
        }
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        if (this.sizeChangeListeners == null) {
            this.sizeChangeListeners = new Array(true, 1);
        }
        this.sizeChangeListeners.add(listener);
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        if (this.sizeChangeListeners == null) {
            return;
        }
        this.sizeChangeListeners.removeValue(listener, false);
    }

    private void notifySizeChangeListeners() {
        if (this.sizeChangeListeners == null) {
            return;
        }
        for (int i = this.sizeChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.sizeChangeListeners.size) {
                i = this.sizeChangeListeners.size - 1;
            }
            SizeChangeListener listener = (SizeChangeListener)this.sizeChangeListeners.get(i);
            listener.sizeChanged(this);
        }
    }

    @Override
    public void forceTo(float x, float y) {
        this.set(x, y);
    }

    @Override
    public void add(float x, float y) {
        super.add(x, y);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void subtract(float x, float y) {
        super.subtract(x, y);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setX(float x) {
        if (x == this.getX()) {
            return;
        }
        super.setX(x);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setY(float y) {
        if (y == this.getY()) {
            return;
        }
        super.setY(y);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void set(float x, float y) {
        if (x == this.getX() && y == this.getY()) {
            return;
        }
        super.set(x, y);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setRadius(float radius) {
        if (radius == this.getRadius()) {
            return;
        }
        super.setRadius(radius);
        this.notifySizeChangeListeners();
    }

    @Override
    public void setCenter(float x, float y) {
        if (x == this.getCenterX() && y == this.getCenterY()) {
            return;
        }
        super.setCenter(x, y);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterX(float x) {
        if (x == this.getCenterX()) {
            return;
        }
        super.setCenterX(x);
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterY(float y) {
        if (y == this.getCenterY()) {
            return;
        }
        super.setCenterY(y);
        this.notifyPositionChangeListeners();
    }

    @Override
    public float getWidth() {
        return this.getRadius() * 2.0f;
    }

    @Override
    public float getHeight() {
        return this.getRadius() * 2.0f;
    }

    @Override
    public Shape getShape() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StaticCollisionCircle that = (StaticCollisionCircle)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

