/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.game;

import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.Viewport;
import org.mini2Dx.core.game.GameResizeListener;
import org.mini2Dx.core.graphics.Graphics;

public abstract class GameContainer {
    public static final int TARGET_FPS = 60;
    public static final float MAXIMUM_DELTA = 0.016666668f;
    protected int width;
    protected int height;
    protected Graphics graphics;
    private boolean isInitialised = false;
    private Array<GameResizeListener> gameResizeListeners;

    public abstract void initialise();

    public abstract void update(float var1);

    public abstract void interpolate(float var1);

    public abstract void render(Graphics var1);

    public abstract void onPause();

    public abstract void onResume();

    public void render() {
        this.graphics.preRender(this.width, this.height);
        this.render(this.graphics);
        this.graphics.postRender();
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        for (GameResizeListener listener : this.gameResizeListeners) {
            listener.onResize(width, height);
        }
    }

    public Stage createStage(Viewport viewport) {
        return this.graphics.createStage(viewport);
    }

    protected void preinit(Graphics g) {
        this.gameResizeListeners = new Array(true, 1);
        this.graphics = g;
    }

    protected void postinit() {
    }

    public void start(Graphics g) {
        this.width = g.getWindowWidth();
        this.height = g.getWindowHeight();
        if (!this.isInitialised) {
            this.preinit(g);
            this.initialise();
            this.postinit();
            this.isInitialised = true;
        }
    }

    public void dispose() {
    }

    public void addResizeListener(GameResizeListener listener) {
        this.gameResizeListeners.add((Object)listener);
    }

    public void removeResizeListener(GameResizeListener listener) {
        this.gameResizeListeners.removeValue((Object)listener, false);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

