/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.game;

import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.mini2Dx.core.game.ApplicationListener;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.LibGdxGraphics;

public abstract class GameWrapper
implements ApplicationListener {
    private final GameContainer gameContainer;
    private final String gameIdentifier;

    public GameWrapper(GameContainer gc, String gameIdentifier) {
        this.gameContainer = gc;
        this.gameIdentifier = gameIdentifier;
    }

    public abstract void initialise(String var1);

    protected Graphics createGraphicsContext() {
        SpriteBatch spriteBatch = new SpriteBatch();
        PolygonSpriteBatch polygonSpriteBatch = new PolygonSpriteBatch();
        ShapeRenderer shapeRenderer = new ShapeRenderer();
        return new LibGdxGraphics(this, spriteBatch, polygonSpriteBatch, shapeRenderer);
    }

    public void create() {
        this.initialise(this.gameIdentifier);
        this.gameContainer.start(this.createGraphicsContext());
    }

    public void resize(int width, int height) {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.resize(width, height);
    }

    @Override
    public void update(float delta) {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.update(delta);
    }

    @Override
    public void interpolate(float alpha) {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.interpolate(alpha);
    }

    public void render() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.render();
    }

    public void pause() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.onPause();
    }

    public void resume() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.onResume();
    }

    public void dispose() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.dispose();
    }

    public abstract boolean isGameWindowReady();
}

