/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.game;

import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.screen.BasicScreenManager;
import org.mini2Dx.core.screen.GameScreen;
import org.mini2Dx.core.screen.ScreenManager;
import org.mini2Dx.core.screen.Transition;

public abstract class ScreenBasedGame
extends GameContainer {
    private ScreenManager<GameScreen> screenManager;

    public abstract int getInitialScreenId();

    @Override
    public void update(float delta) {
        this.screenManager.update(this, delta);
    }

    @Override
    public void interpolate(float alpha) {
        this.screenManager.interpolate(this, alpha);
    }

    @Override
    public void render(Graphics g) {
        this.screenManager.render(this, g);
    }

    @Override
    public void onPause() {
        this.screenManager.onPause();
    }

    @Override
    public void onResume() {
        this.screenManager.onResume();
    }

    public void addScreen(GameScreen screen) {
        screen.initialise(this);
        this.screenManager.addGameScreen(screen);
    }

    public void enterGameScreen(int id, Transition transitionOut, Transition transitionIn) {
        this.screenManager.enterGameScreen(id, transitionOut, transitionIn);
    }

    @Override
    protected void preinit(Graphics g) {
        super.preinit(g);
        this.screenManager = new BasicScreenManager<GameScreen>();
        this.addResizeListener(this.screenManager);
    }

    @Override
    protected void postinit() {
        super.postinit();
        this.screenManager.enterGameScreen(this.getInitialScreenId(), null, null);
    }

    public ScreenManager<GameScreen> getScreenManager() {
        return this.screenManager;
    }
}

