/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.geom.Intersector;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Rectangle;

public class LineSegment {
    private static final Point TMP_INTERSECTION = new Point();
    protected Point pointA;
    protected Point pointB;

    public LineSegment(float x1, float y1, float x2, float y2) {
        this(new Point(x1, y1), new Point(x2, y2));
    }

    public LineSegment(Point pA, Point pB) {
        this.pointA = pA;
        this.pointB = pB;
    }

    public void set(float x1, float y1, float x2, float y2) {
        this.pointA.set(x1, y1);
        this.pointB.set(x2, y2);
    }

    public boolean contains(float x, float y) {
        if (this.pointA.getX() == x && this.pointA.getY() == y) {
            return true;
        }
        if (this.pointB.getX() == x && this.pointB.getY() == y) {
            return true;
        }
        Point p3 = new Point(x, y);
        return p3.isOnLineBetween(this.pointA, this.pointB);
    }

    public boolean intersectsLineSegment(float segmentX1, float segmentY1, float segmentX2, float segmentY2) {
        return Intersector.intersectLineSegments(this.pointA.x, this.pointA.y, this.pointB.x, this.pointB.y, segmentX1, segmentY1, segmentX2, segmentY2);
    }

    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA().x, lineSegment.getPointA().y, lineSegment.getPointB().x, lineSegment.getPointB().y);
    }

    @Deprecated
    public Point getIntersection(LineSegment lineSegment) {
        if (this.getIntersection(lineSegment, TMP_INTERSECTION)) {
            return TMP_INTERSECTION;
        }
        return null;
    }

    public boolean getIntersection(LineSegment lineSegment, Point result) {
        if (!Intersector.intersectLines(this.pointA, this.pointB, lineSegment.getPointA(), lineSegment.getPointB(), result)) {
            return false;
        }
        return result.isOnLineBetween(this.pointA, this.pointB);
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this);
    }

    public Point getPointA() {
        return this.pointA;
    }

    public void setPointA(Point pointA) {
        this.pointA = pointA;
    }

    public Point getPointB() {
        return this.pointB;
    }

    public void setPointB(Point pointB) {
        this.pointB = pointB;
    }

    public float getMinX() {
        if (this.pointA.getX() < this.pointB.getX()) {
            return this.pointA.getX();
        }
        return this.pointB.getX();
    }

    public float getMinY() {
        if (this.pointA.getY() < this.pointB.getY()) {
            return this.pointA.getY();
        }
        return this.pointB.getY();
    }

    public float getMaxX() {
        if (this.pointA.getX() > this.pointB.getX()) {
            return this.pointA.getX();
        }
        return this.pointB.getX();
    }

    public float getMaxY() {
        if (this.pointA.getY() > this.pointB.getY()) {
            return this.pointA.getY();
        }
        return this.pointB.getY();
    }

    public float getLength() {
        return this.pointA.getDistanceTo(this.pointB);
    }

    public String toString() {
        return "LineSegment [pointA=" + (Object)((Object)this.pointA) + ", pointB=" + (Object)((Object)this.pointB) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pointA == null ? 0 : this.pointA.hashCode());
        result = 31 * result + (this.pointB == null ? 0 : this.pointB.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineSegment other = (LineSegment)obj;
        if (this.pointA == null ? other.pointA != null : !this.pointA.equals(other.pointA)) {
            return false;
        }
        return !(this.pointB == null ? other.pointB != null : !this.pointB.equals(other.pointB));
    }
}

