/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;

public class Point
extends Vector2 {
    private static final long serialVersionUID = 3773673953486445831L;

    public Point() {
    }

    public Point(float x, float y) {
        super(x, y);
    }

    public Point(Point point) {
        super((Vector2)point);
    }

    public float getDistanceTo(Point point) {
        return this.dst(point.getX(), point.getY());
    }

    public float getDistanceTo(float x, float y) {
        return this.dst(x, y);
    }

    public void rotateAround(Point center, float degrees) {
        this.rotateAround(center.x, center.y, degrees);
    }

    public void rotateAround(float centerX, float centerY, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        float cos = MathUtils.cos((float)(degrees * ((float)Math.PI / 180)));
        float sin = MathUtils.sin((float)(degrees * ((float)Math.PI / 180)));
        float newX = cos * (this.x - centerX) - sin * (this.y - centerY) + centerX;
        float newY = sin * (this.x - centerX) + cos * (this.y - centerY) + centerY;
        this.set(newX, newY);
    }

    public boolean isOnLineBetween(Point a, Point b) {
        float areaOfTriangle = (a.x * (b.y - this.y) + b.x * (this.y - a.y) + this.x * (a.y - b.y)) / 2.0f;
        if (areaOfTriangle == 0.0f) {
            if (this.x == a.x && this.y == a.y) {
                return true;
            }
            if (this.x == b.x && this.y == b.y) {
                return true;
            }
            if (this.x == a.x) {
                return this.y > a.y && this.y < b.y || this.y > b.y && this.y < a.y;
            }
            return this.x > a.x && this.x < b.x || this.x > b.x && this.x < a.x;
        }
        return false;
    }

    public boolean equals(Vector2 v) {
        return this.x == v.x && this.y == v.y;
    }

    public boolean equals(Vector2 v, float delta) {
        return this.equals(v.x, v.y, delta);
    }

    public boolean equals(float x, float y, float delta) {
        return Math.abs(this.x - x) <= delta && Math.abs(this.y - y) <= delta;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.set(x, this.y);
    }

    public void setY(float y) {
        this.set(this.x, y);
    }

    public Vector2 set(Vector2 v) {
        return this.set(v.x, v.y);
    }

    public Vector2 add(Vector2 v) {
        return this.add(v.x, v.y);
    }

    public Vector2 sub(Vector2 v) {
        return this.sub(v.x, v.y);
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }
}

