/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.GeometryUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.ShortArray;
import java.util.Arrays;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.Intersector;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.Triangle;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.util.EdgeIterator;

public class Polygon
extends Shape {
    private static final String LOGGING_TAG = Polygon.class.getSimpleName();
    private static final LineSegment INTERNAL_EDGE_LINE_SEGMENT = new LineSegment(0.0f, 0.0f, 1.0f, 1.0f);
    private static final Vector2 TMP_VECTOR1 = new Vector2();
    private static final Vector2 TMP_VECTOR2 = new Vector2();
    private final EarClippingTriangulator triangulator;
    private final PolygonEdgeIterator edgeIterator = new PolygonEdgeIterator();
    private final PolygonEdgeIterator internalEdgeIterator = new PolygonEdgeIterator(INTERNAL_EDGE_LINE_SEGMENT);
    private final Vector2 centroid = new Vector2();
    private float[] vertices;
    private float rotation = 0.0f;
    private int totalSidesCache = -1;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private ShortArray triangles;
    private boolean isRectangle;
    private boolean isEquilateral;
    private boolean minMaxDirty = true;
    private boolean trianglesDirty = true;
    private boolean centroidDirty = true;

    public Polygon(float[] vertices) {
        this.vertices = vertices;
        this.triangulator = new EarClippingTriangulator();
        this.getNumberOfSides();
    }

    public Polygon(Vector2[] points) {
        this(Polygon.toVertices(points));
    }

    public boolean isSameAs(Polygon polygon) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] == polygon.vertices[i]) continue;
            return false;
        }
        return true;
    }

    public Polygon lerp(Polygon target, float alpha) {
        float inverseAlpha = 1.0f - alpha;
        float[] currentVertices = this.vertices;
        float[] targetVertices = target.vertices;
        if (currentVertices.length != targetVertices.length) {
            throw new MdxException("Cannot lerp polygons with different vertice amounts");
        }
        if (this.getRotation() != target.getRotation()) {
            float newRotation = this.rotation * inverseAlpha + target.getRotation() * alpha;
            if (this.getX() == target.getX() && this.getY() == target.getY()) {
                this.setRotation(newRotation);
            } else {
                this.setRotationAround(currentVertices[0] * inverseAlpha + targetVertices[0] * alpha, currentVertices[1] * inverseAlpha + targetVertices[1] * alpha, newRotation);
            }
        } else if (!this.isSameAs(target)) {
            for (int i = 0; i < currentVertices.length; i += 2) {
                currentVertices[i] = currentVertices[i] * inverseAlpha + targetVertices[i] * alpha;
                currentVertices[i + 1] = currentVertices[i + 1] * inverseAlpha + targetVertices[i + 1] * alpha;
            }
            this.vertices = currentVertices;
            this.setDirty();
        }
        return this;
    }

    @Override
    public Shape copy() {
        Polygon result = new Polygon(Arrays.copyOf(this.vertices, this.vertices.length));
        result.rotation = this.rotation;
        return result;
    }

    private void clearTotalSidesCache() {
        this.totalSidesCache = -1;
    }

    protected boolean triangleContains(float x, float y, float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
        boolean b1 = this.sign(x, y, p1x, p1y, p2x, p2y) < 0.0f;
        boolean b2 = this.sign(x, y, p2x, p2y, p3x, p3y) < 0.0f;
        boolean b3 = this.sign(x, y, p3x, p3y, p1x, p1y) < 0.0f;
        return b1 == b2 && b2 == b3;
    }

    protected float sign(float x, float y, float p1x, float p1y, float p2x, float p2y) {
        return (x - p2x) * (p1y - p2y) - (p1x - p2x) * (y - p2y);
    }

    @Override
    public boolean contains(float x, float y) {
        if (this.isRectangle) {
            return this.triangleContains(x, y, this.vertices[0], this.vertices[1], this.vertices[2], this.vertices[3], this.vertices[6], this.vertices[7]) || this.triangleContains(x, y, this.vertices[6], this.vertices[7], this.vertices[2], this.vertices[3], this.vertices[4], this.vertices[5]);
        }
        int intersects = 0;
        for (int i = 0; i < this.vertices.length; i += 2) {
            float x1 = this.vertices[i];
            float y1 = this.vertices[i + 1];
            float x2 = this.vertices[(i + 2) % this.vertices.length];
            float y2 = this.vertices[(i + 3) % this.vertices.length];
            if (!(y1 <= y && y < y2) && (!(y2 <= y) || !(y < y1)) || !(x < (x2 - x1) / (y2 - y1) * (y - y1) + x1)) continue;
            ++intersects;
        }
        return intersects & true;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.contains(vector2.x, vector2.y);
    }

    @Override
    public boolean contains(Shape shape) {
        if (shape.isCircle()) {
            Rectangle circleBox = ((Circle)shape).getBoundingBox();
            return this.contains(circleBox.getPolygon());
        }
        return this.contains(shape.getPolygon());
    }

    public boolean contains(Polygon polygon) {
        return Intersector.containsPolygon(this, polygon);
    }

    @Override
    public boolean intersects(Shape shape) {
        if (shape.isCircle()) {
            return this.intersects((Circle)shape);
        }
        return this.intersects(shape.getPolygon());
    }

    public boolean intersects(Polygon polygon) {
        this.minMaxDirtyCheck();
        polygon.minMaxDirtyCheck();
        if (this.isRectangle && polygon.isRectangle) {
            boolean xAxisOverlaps = true;
            boolean yAxisOverlaps = true;
            if (this.maxX < polygon.minX) {
                xAxisOverlaps = false;
            }
            if (polygon.maxX < this.minX) {
                xAxisOverlaps = false;
            }
            if (this.maxY < polygon.minY) {
                yAxisOverlaps = false;
            }
            if (polygon.maxY < this.minY) {
                yAxisOverlaps = false;
            }
            return xAxisOverlaps && yAxisOverlaps;
        }
        if (polygon.minX > this.maxX) {
            return false;
        }
        if (polygon.maxX < this.minX) {
            return false;
        }
        if (polygon.minY > this.maxY) {
            return false;
        }
        if (polygon.maxY < this.minY) {
            return false;
        }
        boolean result = false;
        this.internalEdgeIterator.begin();
        while (this.internalEdgeIterator.hasNext()) {
            this.internalEdgeIterator.next();
            if (!polygon.intersects(this.internalEdgeIterator.getEdgeLineSegment())) continue;
            result = true;
            break;
        }
        this.internalEdgeIterator.end();
        return result;
    }

    public boolean intersects(Triangle triangle) {
        return this.intersects(triangle.polygon);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.intersects(rectangle.polygon);
    }

    public boolean intersects(Circle circle) {
        if (this.isRectangle) {
            this.minMaxDirtyCheck();
            float closestX = circle.getX();
            float closestY = circle.getY();
            if (circle.getX() < this.minX) {
                closestX = this.minX;
            } else if (circle.getX() > this.maxX) {
                closestX = this.maxX;
            }
            if (circle.getY() < this.minY) {
                closestY = this.minY;
            } else if (circle.getY() > this.maxY) {
                closestY = this.maxY;
            }
            closestX -= circle.getX();
            closestX *= closestX;
            closestY -= circle.getY();
            closestY *= closestY;
            return closestX + closestY < circle.getRadius() * circle.getRadius();
        }
        boolean result = false;
        this.internalEdgeIterator.begin();
        while (this.internalEdgeIterator.hasNext()) {
            this.internalEdgeIterator.next();
            if (!circle.intersectsLineSegment(this.internalEdgeIterator.getPointAX(), this.internalEdgeIterator.getPointAY(), this.internalEdgeIterator.getPointBX(), this.internalEdgeIterator.getPointBY())) continue;
            result = true;
            break;
        }
        this.internalEdgeIterator.end();
        return result;
    }

    @Override
    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA(), lineSegment.getPointB());
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        return Intersector.intersectSegmentPolygon(pointA, pointB, this.vertices);
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        TMP_VECTOR1.set(x1, y1);
        TMP_VECTOR2.set(x2, y2);
        return Intersector.intersectSegmentPolygon(TMP_VECTOR1, TMP_VECTOR2, this.vertices);
    }

    @Override
    public float getDistanceTo(float x, float y) {
        float result = com.badlogic.gdx.math.Intersector.distanceSegmentPoint((float)this.vertices[this.vertices.length - 2], (float)this.vertices[this.vertices.length - 1], (float)this.vertices[0], (float)this.vertices[1], (float)x, (float)y);
        for (int i = 0; i < this.vertices.length - 2; i += 2) {
            float distance = com.badlogic.gdx.math.Intersector.distanceSegmentPoint((float)this.vertices[i], (float)this.vertices[i + 1], (float)this.vertices[i + 2], (float)this.vertices[i + 3], (float)x, (float)y);
            if (!(distance < result)) continue;
            result = distance;
        }
        return result;
    }

    public void addPoint(float x, float y) {
        float[] existingVertices = this.vertices;
        float[] newVertices = new float[existingVertices.length + 2];
        if (existingVertices.length > 0) {
            System.arraycopy(existingVertices, 0, newVertices, 0, existingVertices.length);
        }
        newVertices[existingVertices.length] = x;
        newVertices[existingVertices.length + 1] = y;
        this.vertices = newVertices;
        this.clearTotalSidesCache();
        this.setDirty();
    }

    public void addPoint(Vector2 point) {
        this.addPoint(point.x, point.y);
    }

    private void removePoint(int i) {
        float[] existingVertices = this.vertices;
        float[] newVertices = new float[existingVertices.length - 2];
        if (i > 0) {
            System.arraycopy(existingVertices, 0, newVertices, 0, i);
        }
        if (i < existingVertices.length - 2) {
            System.arraycopy(existingVertices, i + 2, newVertices, i, existingVertices.length - i - 2);
        }
        this.vertices = newVertices;
        this.setDirty();
        this.clearTotalSidesCache();
    }

    public void removePoint(float x, float y) {
        float[] existingVertices = this.vertices;
        for (int i = 0; i < existingVertices.length; i += 2) {
            if (existingVertices[i] != x || existingVertices[i + 1] != y) continue;
            this.removePoint(i);
            return;
        }
    }

    public void removePoint(Vector2 point) {
        this.removePoint(point.x, point.y);
    }

    private void checkSidesCache() {
        if (this.totalSidesCache >= 0) {
            return;
        }
        this.totalSidesCache = this.vertices.length / 2;
        this.isRectangle = this.totalSidesCache == 4;
        this.isEquilateral = this.isEquilateral(1.0E-6f);
    }

    @Override
    public int getNumberOfSides() {
        this.checkSidesCache();
        return this.totalSidesCache;
    }

    @Override
    public void draw(Graphics g) {
        g.drawPolygon(this.vertices);
    }

    @Override
    public void fill(Graphics g) {
        g.fillPolygon(this.vertices, this.getTriangles().items);
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void setVertices(float[] vertices) {
        boolean changed = false;
        if (this.vertices.length == vertices.length * 2) {
            for (int i = 0; i < vertices.length; ++i) {
                changed |= !MathUtils.isEqual((float)this.vertices[i], (float)vertices[i]);
            }
        } else {
            changed = true;
        }
        this.rotation = 0.0f;
        if (!changed) {
            return;
        }
        this.vertices = vertices;
        this.clearTotalSidesCache();
        this.setDirty();
    }

    public void setVertices(Vector2[] vertices) {
        if (this.vertices.length != vertices.length * 2) {
            this.setVertices(Polygon.toVertices(vertices));
            return;
        }
        boolean changed = false;
        for (int i = 0; i < vertices.length; ++i) {
            int index = i * 2;
            changed |= !MathUtils.isEqual((float)this.vertices[index], (float)vertices[i].x);
            changed |= !MathUtils.isEqual((float)this.vertices[index + 1], (float)vertices[i].y);
            this.vertices[index] = vertices[i].x;
            this.vertices[index + 1] = vertices[i].y;
        }
        this.rotation = 0.0f;
        if (!changed) {
            return;
        }
        this.clearTotalSidesCache();
        this.setDirty();
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float degrees) {
        this.setRotationAround(this.vertices[0], this.vertices[1], degrees);
    }

    @Override
    public void rotate(float degrees) {
        this.rotateAround(this.vertices[0], this.vertices[1], degrees);
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        if (this.rotation == degrees && centerX == this.getX() && centerY == this.getY()) {
            return;
        }
        this.rotateAround(centerX, centerY, degrees - this.rotation);
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        this.rotation += degrees;
        float cos = MathUtils.cos((float)(degrees * ((float)Math.PI / 180)));
        float sin = MathUtils.sin((float)(degrees * ((float)Math.PI / 180)));
        for (int i = 0; i < this.vertices.length; i += 2) {
            float x = this.vertices[i];
            float y = this.vertices[i + 1];
            this.vertices[i] = cos * (x - centerX) - sin * (y - centerY) + centerX;
            this.vertices[i + 1] = sin * (x - centerX) + cos * (y - centerY) + centerY;
        }
        this.setDirty();
    }

    @Override
    public float getX() {
        return this.getX(0);
    }

    @Override
    public float getY() {
        return this.getY(0);
    }

    public float getX(int index) {
        return this.vertices[index * 2];
    }

    public float getY(int index) {
        return this.vertices[index * 2 + 1];
    }

    @Override
    public float getCenterX() {
        if (this.centroidDirty) {
            GeometryUtils.polygonCentroid((float[])this.vertices, (int)0, (int)this.vertices.length, (Vector2)this.centroid);
            this.centroidDirty = false;
        }
        return this.centroid.x;
    }

    @Override
    public float getCenterY() {
        if (this.centroidDirty) {
            GeometryUtils.polygonCentroid((float[])this.vertices, (int)0, (int)this.vertices.length, (Vector2)this.centroid);
            this.centroidDirty = false;
        }
        return this.centroid.y;
    }

    @Override
    public void setCenter(float x, float y) {
        float centerX = this.getCenterX();
        float centerY = this.getCenterY();
        if (x == centerX && y == centerY) {
            return;
        }
        this.translate(x - centerX, y - centerY);
    }

    @Override
    public void setCenterX(float x) {
        float centerX = this.getCenterX();
        if (x == centerX) {
            return;
        }
        this.translate(x - centerX, 0.0f);
    }

    @Override
    public void setCenterY(float y) {
        float centerY = this.getCenterY();
        if (y == centerY) {
            return;
        }
        this.translate(0.0f, y - centerY);
    }

    @Override
    public float getMinX() {
        this.minMaxDirtyCheck();
        return this.minX;
    }

    @Override
    public float getMinY() {
        this.minMaxDirtyCheck();
        return this.minY;
    }

    @Override
    public float getMaxX() {
        this.minMaxDirtyCheck();
        return this.maxX;
    }

    @Override
    public float getMaxY() {
        this.minMaxDirtyCheck();
        return this.maxY;
    }

    public ShortArray getTriangles() {
        this.trianglesDirtyCheck();
        return this.triangles;
    }

    private static float[] toVertices(Vector2[] points) {
        if (points == null) {
            throw new MdxException(Point.class.getSimpleName() + " array cannot be null");
        }
        if (points.length < 3) {
            throw new MdxException(Point.class.getSimpleName() + " must have at least 3 points");
        }
        float[] result = new float[points.length * 2];
        for (int i = 0; i < points.length; ++i) {
            int index = i * 2;
            result[index] = points[i].x;
            result[index + 1] = points[i].y;
        }
        return result;
    }

    @Override
    public void setX(float x) {
        if (x == this.getX()) {
            return;
        }
        float xDiff = x - this.getX();
        for (int i = 0; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + xDiff;
        }
        this.setDirty();
    }

    @Override
    public void setY(float y) {
        if (y == this.getY()) {
            return;
        }
        float yDiff = y - this.getY();
        for (int i = 1; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + yDiff;
        }
        this.setDirty();
    }

    @Override
    public void set(float x, float y) {
        if (x == this.getX() && y == this.getY()) {
            return;
        }
        float xDiff = x - this.getX();
        float yDiff = y - this.getY();
        for (int i = 0; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + xDiff;
            int n2 = i + 1;
            this.vertices[n2] = this.vertices[n2] + yDiff;
        }
        this.setDirty();
    }

    @Override
    public void setRadius(float radius) {
        TMP_VECTOR1.set(this.vertices[0], this.vertices[1]);
        this.scale(radius / TMP_VECTOR1.dst(this.getCenterX(), this.getCenterY()));
    }

    @Override
    public void scale(float scale) {
        if (!this.isEquilateral()) {
            Gdx.app.error(LOGGING_TAG, "Cannot set radius on non-equilateral Polygon");
            return;
        }
        for (int i = 0; i < this.vertices.length; i += 2) {
            TMP_VECTOR1.set(this.vertices[i], this.vertices[i + 1]);
            TMP_VECTOR1.sub(this.getCenterX(), this.getCenterY());
            TMP_VECTOR1.scl(scale);
            TMP_VECTOR1.add(this.vertices[i], this.vertices[i + 1]);
            this.vertices[i] = Polygon.TMP_VECTOR1.x;
            this.vertices[i + 1] = Polygon.TMP_VECTOR1.y;
        }
        this.setDirty();
        this.centroidDirty = false;
    }

    public void set(Polygon polygon) {
        this.vertices = polygon.vertices;
        this.rotation = polygon.rotation;
        this.clearTotalSidesCache();
        this.setDirty();
    }

    @Override
    public void translate(float translateX, float translateY) {
        for (int i = 0; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + translateX;
            int n2 = i + 1;
            this.vertices[n2] = this.vertices[n2] + translateY;
        }
        this.setDirty();
    }

    @Override
    public EdgeIterator edgeIterator() {
        return this.edgeIterator;
    }

    public boolean isEquilateral() {
        this.checkSidesCache();
        return this.isEquilateral;
    }

    public boolean isEquilateral(float tolerance) {
        if (this.isRectangle()) {
            return MathUtils.isEqual((float)(this.getMaxX() - this.getX()), (float)(this.getMaxY() - this.getY()), (float)tolerance);
        }
        PolygonEdgeIterator edgeIterator = new PolygonEdgeIterator();
        edgeIterator.begin();
        edgeIterator.next();
        float length = edgeIterator.getEdgeLineSegment().getLength();
        while (edgeIterator.hasNext()) {
            edgeIterator.next();
            float nextLength = edgeIterator.getEdgeLineSegment().getLength();
            if (MathUtils.isEqual((float)length, (float)nextLength, (float)tolerance)) continue;
            edgeIterator.end();
            return false;
        }
        edgeIterator.end();
        return true;
    }

    public boolean isRectangle() {
        this.checkSidesCache();
        return this.isRectangle;
    }

    @Override
    public boolean isCircle() {
        return false;
    }

    @Override
    public Polygon getPolygon() {
        return this;
    }

    boolean isDirty() {
        return this.minMaxDirty || this.trianglesDirty || this.centroidDirty;
    }

    private void setDirty() {
        this.minMaxDirty = true;
        this.trianglesDirty = true;
        this.centroidDirty = true;
    }

    private void minMaxDirtyCheck() {
        if (!this.minMaxDirty) {
            return;
        }
        this.calculateMinMaxXY(this.vertices);
        this.minMaxDirty = false;
    }

    private void trianglesDirtyCheck() {
        if (!this.trianglesDirty) {
            return;
        }
        this.computeTriangles(this.vertices);
        this.trianglesDirty = false;
    }

    private void computeTriangles(float[] vertices) {
        this.triangles = this.triangulator.computeTriangles(vertices);
    }

    private void calculateMinMaxXY(float[] vertices) {
        int minXIndex = 0;
        int minYIndex = 1;
        int maxXIndex = 0;
        int maxYIndex = 1;
        for (int i = 2; i < vertices.length; i += 2) {
            if (vertices[i] < vertices[minXIndex]) {
                minXIndex = i;
            }
            if (vertices[i + 1] < vertices[minYIndex]) {
                minYIndex = i + 1;
            }
            if (vertices[i] > vertices[maxXIndex]) {
                maxXIndex = i;
            }
            if (!(vertices[i + 1] > vertices[maxYIndex])) continue;
            maxYIndex = i + 1;
        }
        this.minX = vertices[minXIndex];
        this.minY = vertices[minYIndex];
        this.maxX = vertices[maxXIndex];
        this.maxY = vertices[maxYIndex];
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.vertices);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        return Arrays.equals(this.vertices, other.vertices);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.vertices.length; i += 2) {
            result.append("[");
            result.append(this.vertices[i]);
            result.append(",");
            result.append(this.vertices[i + 1]);
            result.append("]");
        }
        return result.toString();
    }

    private class PolygonEdgeIterator
    extends EdgeIterator {
        private int edge = 0;
        private final LineSegment edgeLineSegment;

        public PolygonEdgeIterator() {
            this(new LineSegment(0.0f, 0.0f, 1.0f, 1.0f));
        }

        public PolygonEdgeIterator(LineSegment edgeLineSegment) {
            this.edgeLineSegment = edgeLineSegment;
        }

        @Override
        protected void beginIteration() {
            this.edge = -1;
        }

        @Override
        protected void endIteration() {
        }

        @Override
        protected void nextEdge() {
            if (this.edge >= Polygon.this.getNumberOfSides()) {
                throw new MdxException("No more edges remaining. Make sure to call end()");
            }
            ++this.edge;
            if (!this.hasNext()) {
                return;
            }
            this.edgeLineSegment.set(this.getPointAX(), this.getPointAY(), this.getPointBX(), this.getPointBY());
        }

        @Override
        public boolean hasNext() {
            return this.edge < Polygon.this.getNumberOfSides() - 1;
        }

        @Override
        public float getPointAX() {
            if (this.edge < 0) {
                throw new MdxException("Make sure to call next() after beginning iteration");
            }
            return Polygon.this.vertices[this.edge * 2];
        }

        @Override
        public float getPointAY() {
            if (this.edge < 0) {
                throw new MdxException("Make sure to call next() after beginning iteration");
            }
            return Polygon.this.vertices[this.edge * 2 + 1];
        }

        @Override
        public float getPointBX() {
            if (this.edge < 0) {
                throw new MdxException("Make sure to call next() after beginning iteration");
            }
            if (this.edge == Polygon.this.getNumberOfSides() - 1) {
                return Polygon.this.vertices[0];
            }
            return Polygon.this.vertices[(this.edge + 1) * 2];
        }

        @Override
        public float getPointBY() {
            if (this.edge < 0) {
                throw new MdxException("Make sure to call next() after beginning iteration");
            }
            if (this.edge == Polygon.this.getNumberOfSides() - 1) {
                return Polygon.this.vertices[1];
            }
            return Polygon.this.vertices[(this.edge + 1) * 2 + 1];
        }

        @Override
        public LineSegment getEdgeLineSegment() {
            return this.edgeLineSegment;
        }
    }
}

